import request from '@/utils/request'

// 获取文件夹结构
export function getReportFolderStructureAPI(params) {
  return request({
    url: `/report/jmreport/category/list`,
    params
  })
}

// 获取报表设计中的报表列表
export function getDesignReportListAPI(params) {
  return request({
    url: `/report/jmreport/query/report/folder`,
    params
  })
}

// 删除报表
export function deleteReportAPI(params) {
  return request({
    url: `/report/jmreport/delete`,
    method: 'DELETE',
    params,
    data: params
  })
}

// 复制报表
export function copyReportAPI(params) {
  return request({
    url: `/report/jmreport/reportCopy`,
    params
  })
}

// 新建报表（需要先调用接口创建一个 id，传给新建页面）
export function addReportAPI() {
  return request({
    url: `/report/jmreport/save`,
    method: 'POST',
    data: {}
  })
}

// 导入报表（报表来自积木设计页面右键导出报表配置 json 文件的导入）
export function importReportAPI(data) {
  return request({
    url: `/report/jmreport/importReportConfig`,
    method: 'POST',
    data,
     headers: {
      'Content-Type': 'multipart/form-data'
    }
  })
}
