// 竞品店铺对应颜色
const BRAND_COLOR = {
  // #5470c6 #0099cc #0720F0 #0062EB
  // #00EFDC #66ccff #00EF5A #00DDEB
  // #91cc75 #3ba272 #00cc99 #A1EB00
  // #fac858 #EBE098 #F0EA07 #EF8912
  // #c23531 #fc8452 #ff6699 #cc0066 #ee6666
  // #CE09EB #E7A2EB #8409EB #EB00B4

  '三只松鼠': ['#5470c6', '#00EFDC', '#91cc75', '#fac858'],
  '三只松鼠官方旗舰店直播间': ['#91cc75', '#c23531', '#CE09EB', '#0099cc'],
  '百草味坚果旗舰店': ['#ee6666', '#66ccff', '#3ba272', '#EBE098'],
  '百草味官方旗舰店': ['#00EFDC', '#E7A2EB', '#fc8452', '#0720F0'],

  '三只松鼠旗舰店': ['#00EF5A', '#00cc99', '#F0EA07', '#ff6699'],
  '沃隆旗舰店': ['#8409EB', '#0062EB', '#00DDEB', '#A1EB00'],
  '盐津铺子食品旗舰店': ['#EF8912', '#cc0066', '#EB00B4', '#ee6666'],
  '藤桥官方旗舰店': ['#CE09EB', '#5470c6', '#0099cc', '#66ccff'],

  '好利来官方旗舰店': ['#E7A2EB', '#0720F0', '#00EF5A', '#F0EA07'],
  '炭食光食品旗舰店': ['#ff6699', '#8409EB', '#0062EB', '#00DDEB'],
  '周黑鸭食品旗舰店': ['#8409EB', '#A1EB00', '#EF8912', '#cc0066'],
  '良品铺子旗舰店': ['#A1EB00', '#EB00B4', '#ee6666', '#5470c6'],
  '德芙官方旗舰店': ['#00cc99', '#00EFDC', '#91cc75', '#c23531'],
  '洽洽食品官方旗舰店': ['#cc0066', '#CE09EB', '#0099cc', '#3ba272'],
  '蒙都旗舰店': ['#66ccff', '#EBE098', '#fc8452', '#5470c6'],
  '脱骨侠旗舰店': ['#EBE098', '#91cc75', '#5470c6', '#E7A2EB'],
  '比比赞旗舰店': ['#0099cc', '#ff6699', '#00EF5A', '#cc0066'],
}
/**
 * 通过直播间/店铺名字取出它的颜色数据
 * @param {*} brand 直播间店铺名字
 * @param {*} index 是取第几个颜色
 * @returns 16进制颜色
 */
export const getBrandColor = (brand, index = 0) => {
  if (BRAND_COLOR[brand]) {
    return BRAND_COLOR[brand][index]
  } else {
    return getRandomColor()
  }
}

// 按顺序循环取颜色
export const getAdditionalColor = (index = 0) => {
  const ADDITIONAL_COLORS = [
    '#5470c6', '#00EFDC', '#91cc75', '#fac858', '#0062EB', '#c23531',
    '#66ccff', '#CE09EB', '#00EF5A', '#EBE098', '#00DDEB', '#F0EA07',
    '#3ba272', '#EF8912', '#fc8452', '#00cc99', '#ff6699', '#A1EB00',
    '#cc0066', '#8409EB', '#0720F0', '#ee6666', '#E7A2EB', '#0099cc',
    '#EB00B4'
  ];
  return ADDITIONAL_COLORS[index % ADDITIONAL_COLORS.length];
}


// 生成 16 进制随机颜色
const getRandomColor = () => {
  let color = Math.floor(Math.random() * 16777215).toString(16);
  // 检查颜色字符串的长度，如果不足6位，则在前面补0
  while (color.length < 6) {
    color = '0' + color;
  }
  return '#' + color;
}

