export const useDatePickerOptions = () => {
  const pickerOptions = ref([// 日期选项配置
    {
      text: '最近一周',
      value() {
        const end = new Date().setDate((new Date().getDate() - 1));
        const start = new Date();
        start.setTime(start.getTime() - 3600 * 1000 * 24 * 7);
        return [start, end]
      }
    }, {
      text: '最近一个月',
      value() {
        const end = new Date().setDate((new Date().getDate() - 1));
        const start = new Date();
        start.setTime(start.getTime() - 3600 * 1000 * 24 * 30);
        return [start, end]
      }
    }
  ])
  return {
    pickerOptions
  }
}