// 封装从 URL 的查询参数找到要求的 key 对应的值
export function getQueryString(name) {
  // 先尝试从 search 中获取查询参数
  let search = window.location.search.substr(1);
  // 再尝试从 hash 中获取查询参数
  const hashIndex = window.location.href.indexOf('?', window.location.href.indexOf('#'));
  if (hashIndex !== -1) {
    search += '&' + window.location.href.slice(hashIndex + 1);
  }
  var reg = new RegExp('(^|&)' + name + '=([^&]*)(&|$)', 'i');
  var r = search.match(reg);
  if (r != null) {
    return decodeURIComponent(r[2]);
  } else {
    return null;
  }
}