import request from '@/utils/request'

// 获取系列数据列表（左侧树）
export const getSeriesListAPI = () => {
  return request({
    url: '/bi/prd/query/series'
  })
}

// 获取商品列表
export const getProductListAPI = (params) => {
  return request({
    url: '/bi/prd/query',
    params
  })
}

// 创建商品标签集合
export function createSeriesGoodsTagAPI(data) {
  return request({
    url: '/bi/prd_tage/core',
    method: 'post',
    data
  })
}

// 查询商品标签集合列表
export function getSeriesGoodsTagListAPI(params) {
  return request({
    url: '/bi/prd_tage/query/page',
    params
  })
}

// 查询商品标签详情
export function getPrdTagDetailAPI(params) {
  return request({
    url: '/bi/prd_tage/query/infos',
    params
  })
}

// 删除商品标签
export function deleteSeriesGoodsTagAPI(tagId) {
  return request({
    url: '/bi/prd_tage/core/' + tagId,
    method: 'delete'
  })
}