import request from '@/utils/request'
// 获取积木报表列表
export function getReportListAPI(params) {
  return request({
    url: '/report/customer/share/list',
    params
  })
}
// 获取自定义报表列表
export function getReportListBySelfAPI() {
  return request({
    url: '/report/customer/query/list'
  })
}

// 自定义分组报表列表查询
export function getReportListByGroupAPI(params) {
  return request({
    url: '/report/customer/query/group/list',
    params
  })
}

// 自定义分组新增
export function addReportGroupAPI(data) {
  return request({
    url: '/report/customer/core/group/save',
    method: 'post',
    data
  }) 
}

// 新增/编辑自定义分组
export function editReportGroupAPI(data) {
  return request({
    url: '/report/customer/core/group/insertOrUpdate',
    method: 'post',
    data
  }) 
}