export function getFileTypeExt(url) {
  const fileName = url.split('/').pop()
  const fileType = fileName.split('.').pop()
  return fileType
}

// 判断 URL 是一个图片还是视频
function isImage(url) {
  console.log(url, '1')
  const fileType = getFileTypeExt(url)
  return ['jpg', 'jpeg', 'png', 'gif', 'bmp'].includes(fileType.toLowerCase())
}
// 判断 URL 是一个视频
function isVideo(url) {
  const fileType = getFileTypeExt(url)
  console.log(['mp4', 'avi', 'mov', 'wmv', 'flv', '3gp', 'mkv', 'webm'].includes(fileType.toLowerCase()), 2)
  return ['mp4', 'avi', 'mov', 'wmv', 'flv', '3gp', 'mkv', 'webm'].includes(fileType.toLowerCase())
}
// 来个统一出口
export function getMediaType(url) {
  if (isImage(url)) {
    return 'image'
  } else if (isVideo(url)) {
    return 'video'
  } else {
    return 'unknown'
  }
}
