import { onMounted, onBeforeUnmount } from 'vue';
import useAppStore from '@/store/modules/app';
const sidebar = computed(() => useAppStore().sidebar);

export function useWindowResize(callback) {

  watch(sidebar, () => {
    // 等待侧边栏导航动画完成，右侧才有最新宽度再 resize
    setTimeout(() => {
      callback()
    }, 300)
  }, { deep: true })

  onMounted(() => {
    window.addEventListener('resize', callback);
  });

  onBeforeUnmount(() => {
    window.removeEventListener('resize', callback);
  });
}