import request from '@/utils/request'
import { parseTime } from '@/utils'
const VITE_APP_PROMOTION = import.meta.env.VITE_APP_PROMOTION

// 战区列表
export const getWarZoneListAPI = () => {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: '/user/dept/query/enroll/list',
    method: 'POST',
    data: {
      "orgNameLike1": "战区",
      "orgName1": "重客销售部"
    }
  })
}

// 负责人列表
export const getChargeListAPI = () => {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: '/user/employee/query/list',
    method: 'POST',
    data: {
      "waiqin365OrgId": '',
      "empName": '',
      "qcId": ''
    }
  })
}

// 任务列表
export const getTaskListAPI = (queryParams) => {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: '/activity/employee/query/page',
    // headers: {
    //   isToken: false,
    //   'Authorization': 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1c2VybmFtZSI6IjAwMDUxNiIsInBhc3N3b3JkIjoid3hsMDAwNTE2IiwidGltZSI6MTczNzA4MjM3ODQ0MX0.z8pOrprMgfOk5MGEKCL-KNokLgCPqDRt8suEYEnnQ-U',
    // },
    method: 'POST',
    data: {
      "pageNum": queryParams.page,
      "pageSize": queryParams.pageSize,
      "queryParams": {
        "deptQcId": queryParams.zoneId,
        "createDateStart": parseTime(queryParams.date[0], '{y}-{m}-{d}'),
        // "createDateStart": '2025-01-12 00:00:00',
        "createDateEnd": parseTime(queryParams.date[1], '{y}-{m}-{d}'),
        // "createDateEnd": '2025-01-14 23:59:59',
        "province": queryParams.province,
        "city": queryParams.city,
        "approverId": '',
        "approveStatus": queryParams.taskStatus,
        "storeNameLike": queryParams.storeName,
      }
    }
  })
}



// 促销系统权限开通
export function openPromotionSystemAPI(data) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: '/user/employee/core/account',
    method: 'POST',
    data
  })  
}

// 删除促销员打卡记录
export function deletePromotionSystemAPI(id) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: `/activity/employee/core/delete/${id}`,
    method: 'DELETE'
  }) 
}

// 促销员打卡记录查询（上下班卡）
export function getPromotionSystemAPI(id) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: `/temporary/clock/query/id`,
    params: {
      id
    }
  }) 
}

// 促销员活动记录查询（推广照片）
export function getPromotionActivityAPI(id) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: `/activity/temporary/query/${id}`
  })
}