import { createApp } from 'vue'
import App from './App'
import store from './store'
import router from './router'
import directive from './directive' // directive
import './permission' // permission control
import plugins from './plugins' // plugins

/****************** 组件 ******************/
import ElementPlus from 'element-plus'
import 'element-plus/dist/index.css'
import 'element-plus/theme-chalk/dark/css-vars.css' // 暗黑模式变量
import locale from 'element-plus/es/locale/lang/zh-cn'
import '@/assets/styles/index.scss'

/****************** 插件 ******************/
import Cookies from 'js-cookie'
import { download } from '@/utils/request'
import 'virtual:svg-icons-register'  // svg图标
import SvgIcon from '@/components/SvgIcon'
import elementIcons from '@/components/SvgIcon/svgicon'
import { useDict } from '@/utils/dict'
import { parseTime, resetForm, addDateRange, handleTree, selectDictLabel, selectDictLabels } from '@/utils'

// 分页组件
import Pagination from '@/components/Pagination'
// 自定义表格工具组件
import RightToolbar from '@/components/RightToolbar'
// 富文本组件
import Editor from "@/components/Editor"
// 文件上传组件
import FileUpload from "@/components/FileUpload"
// 图片上传组件
import ImageUpload from "@/components/ImageUpload"
// 图片预览组件
import ImagePreview from "@/components/ImagePreview"
// 字典标签组件
import DictTag from '@/components/DictTag'
// 常用菜单
import CommonMenu from '@/components/CommonMenu'
// 页面工具球
import LevitatedSphere from '@/components/LevitatedSphere'
// 自定义图例组件
import GroupLegend from '@/components/ECharts/GroupLegend'
// 无数据
import NoData from '@/components/NoData'

const app = createApp(App)

// 全局方法挂载
app.config.globalProperties.useDict = useDict
app.config.globalProperties.download = download
app.config.globalProperties.parseTime = parseTime
app.config.globalProperties.resetForm = resetForm
app.config.globalProperties.handleTree = handleTree
app.config.globalProperties.addDateRange = addDateRange
app.config.globalProperties.selectDictLabel = selectDictLabel
app.config.globalProperties.selectDictLabels = selectDictLabels

// 全局组件挂载
app.component('DictTag', DictTag)
app.component('Pagination', Pagination)
app.component('FileUpload', FileUpload)
app.component('ImageUpload', ImageUpload)
app.component('ImagePreview', ImagePreview)
app.component('RightToolbar', RightToolbar)
app.component('Editor', Editor)
app.component('CommonMenu', CommonMenu)
app.component('LevitatedSphere', LevitatedSphere)
app.component('GroupLegend', GroupLegend)
app.component('NoData', NoData)

app.use(router)
app.use(store)
app.use(plugins)
app.use(elementIcons)
app.component('svg-icon', SvgIcon)

directive(app)

// 使用element-plus 并且设置全局的大小
app.use(ElementPlus, {
  locale: locale,
  // 支持 large、default、small
  size: Cookies.get('size') || 'default'
})

app.mount('#app')
