
// 移动端 静态路由
export const constantMobileRoutes = [
  {
    path: '/login',
    component: () => import('@/views/login'),
    hidden: true
  },
  {
    path: '/m', // 勤策移动端内跳过来的地址是 /m，我们默认显示菜单页面
    redirect: '/menu'
  },
  // 重点注意：菜单页面的按钮跳转的路由地址，是在后台管理系统配置的，不是在这里的，是需要在后台分配给某个人才有那个路由菜单的配置对象
  {
    path: '/',
    component: () => import('@/views/mobile/index'),
    children: [
      {
        path: 'menu',// 菜单页
        component: () => import('@/views/mobile/pages/menu'),
        name: 'm_menu'
      },
      // CP 促销相关的子页面（暂未进行权限拦截，可以参考若依的 permissions 的字段限制）
      {
        path: 'cp_activity/promotion_plan_detail/:planId', // CP 促销计划，详情页
        component: () => import('@/views/mobile/pages/cp_activity/promotion/plan/detail'),
        name: 'm_promotion_detail',
      },
      {
        path: 'cp_activity/promotion_plan_editing/:planId?', // CP 促销计划，增加，修改
        component: () => import('@/views/mobile/pages/cp_activity/promotion/plan/editing'),
        name: 'm_promotion_editing',
      },
      {
        path: 'cp_activity/examine/:examineId', // CP 促销计划，稽查
        component: () => import('@/views/mobile/pages/cp_activity/examine'),
        name: 'm_promotion_examine',
      },
      // 售点稽查的子页面
      {
        path: 'audit_activity/newTerminal', // 售点稽查_新建终端门店
        component: () => import('@/views/mobile/pages/audit_activity/sales_point_inspection/examine/newTerminal'),
        name: 'newTerminal'
      },
      {
        path: 'audit_activity/taskList', // 售点稽查_稽查记录列表
        component: () => import('@/views/mobile/pages/audit_activity/sales_point_inspection/examine/taskList'),
        name: 'taskList'
      },
      {
        path: 'audit_activity/inspectionTask', // 售点稽查_稽查任务
        component: () => import('@/views/mobile/pages/audit_activity/sales_point_inspection/examine/inspectionTask/index'),
        name: 'inspectionTask'
      },
      {
        path: 'logistics', // 物流信息页面
        component: () => import('@/views/mobile/pages/other/logistics'),
        name: 'logistics'
      }
    ]
  }
]