
// 每个表格里的数据列信息集合
// 常规陈列
export const getDisplayConfig = () => {
  return [
    // {
    //   label: "计划月份",
    //   prop: "salesMonth",
    //   width: 100,
    //   childCol: []
    // },
    {
      label: "大区",
      prop: "regionName",
      childCol: []
    },
    {
      label: "战区",
      prop: "districtName",
      childCol: [],
      width: 110
    },
    {
      label: "城市经理",
      prop: "cityManager",
      childCol: []
    },
    {
      label: '主货架',
      prop: "mainShelf",
      childColumns: [
        {
          label: '计划',
          prop: "planMsStoreCnt",
        },
        {
          label: '执行',
          prop: "execMsStoreCnt",
        },
        {
          label: '执行率',
          prop: "msExecRate",
          width: 90
        }
      ]
    },
    {
      label: '端架',
      prop: "endShelf",
      childColumns: [
        {
          label: '计划',
          prop: "planRegEndcapStoreCnt",
        },
        {
          label: '执行',
          prop: "execRegEndcapStoreCnt",
        },
        {
          label: '执行率',
          prop: "endcapExecRate",
          width: 90
        }
      ]
    },
    {
      label: '地堆',
      prop: "endcapShelf",
      childColumns: [
        {
          label: '计划',
          prop: "planRegGsStoreCnt",
        },
        {
          label: '执行',
          prop: "execRegGsStoreCnt",
        },
        {
          label: '执行率',
          prop: "gsExecRate",
          width: 90
        }
      ]
    },
    {
      label: '多点陈列',
      prop: "multiShelf",
      childColumns: [
        {
          label: '计划',
          prop: "planMpDispStoreCnt",
        },
        {
          label: '执行',
          prop: "execMpDispStoreCnt",
        },
        {
          label: '执行率',
          prop: "mpDispExecRate",
          width: 90
        }
      ]
    },
    {
      label: '挂条陈列',
      prop: "hangShelf",
      childColumns: [
        {
          label: '计划',
          prop: "planHsStoreCnt",
        },
        {
          label: '执行',
          prop: "execHsStoreCnt",
        },
        {
          label: '执行率',
          prop: "HsExecRate",
          width: 90
        }
      ]
    }
  ]
}

// 档期计划
export const getSchedulePlanConfig = (submitChange) => {
  return [
    // {
    //   label: "计划月份",
    //   prop: "salesMonth",
    //   width: 100
    // },
    {
      label: "大区",
      prop: "regionName",
      width: 100
    },
    {
      label: "战区",
      prop: "districtName",
      width: 100
    },
    {
      label: "城市经理",
      prop: "cityManager",
      width: 100
    },
    {
      label: '大区反馈',
      prop: "regionFeedback",
      childColumns: [
        {
          label: '计划',
          prop: "planPromoPeriStoreCnt",
        },
        {
          label: '执行',
          prop: "launchPromoPeriStoreCnt",
        },
        {
          label: '执行率',
          prop: "launchRatePromoPeriExec",
          width: 90
        }
      ]
    },
    {
      label: '规格',
      prop: "spec",
      childColumns: [
        {
          label: '执行',
          prop: "execPsStoreCnt",
        },
        {
          label: '执行率',
          prop: "psExecRatePromoPeriExec",
          width: 90
        }
      ]
    },
    {
      label: '口味',
      prop: "flavor",
      childColumns: [
        {
          label: '执行',
          prop: "execPfStoreCnt",
        },
        {
          label: '执行率',
          prop: "pfExecRatePromoPeriExec",
          width: 90
        }
      ]
    },
    {
      label: '价格',
      prop: "price",
      childColumns: [
        {
          label: '执行',
          prop: "execPpStoreCnt",
        },
        {
          label: '执行率',
          prop: "ppExecRatePromoPeriExec",
          width: 90
        }
      ]
    },
    {
      label: '海报',
      prop: "poster",
      childColumns: [
        {
          label: '计划',
          prop: "planPosterStoreCnt",
        },
        {
          label: '执行',
          prop: "execPosterStoreCnt",
        },
        {
          label: '执行率',
          prop: "posterExecRate",
          width: 90
        }
      ]
    },
  ]
}

// 档期陈列
export const getScheduleDisConfig = (submitChange) => {
  return [
    // {
    //   label: "计划月份",
    //   prop: "salesMonth",
    //   width: 100
    // },
    {
      label: "大区",
      prop: "regionName",
      width: 100
    },
    {
      label: "战区",
      prop: "districtName",
      width: 100
    },
    {
      label: "城市经理",
      prop: "cityManager",
      width: 100
    },
    {
      label: '端架',
      prop: "endShelf",
      childColumns: [
        {
          label: '计划',
          prop: "planEndcapStoreCnt",
        },
        {
          label: '执行',
          prop: "execEndcapStoreCnt",
        },
        {
          label: '执行率',
          prop: "endcapExecRatePromoPeriDisp",
        }
      ]
    },
    {
      label: '地堆',
      prop: "endcapShelf",
      childColumns: [
        {
          label: '计划',
          prop: "planGsStoreCnt",
        },
        {
          label: '执行',
          prop: "execGsStoreCnt",
        },
        {
          label: '执行率',
          prop: "gsExecRatePromoPeriDisp",
        }
      ]
    },
    {
      label: '其他陈列',
      prop: "otherShelf",
      childColumns: [
        {
          label: '计划',
          prop: "planOtherDispStoreCnt",
        },
        {
          label: '执行',
          prop: "execOtherDispStoreCnt",
        },
        {
          label: '执行率',
          prop: "otherDispExecRatePromoPeriDisp",
        }
      ]
    },
  ]
}

// 零食陈列
export const getSnackCofing = (submitChange) => {
  return [
    // {
    //   label: "计划月份",
    //   prop: "salesMonth",
    //   width: 100
    // },
    {
      label: "大区",
      prop: "regionName",
      width: 100
    },
    {
      label: "战区",
      prop: "districtName",
      width: 100
    },
    {
      label: "城市经理",
      prop: "cityManager",
      width: 100
    },
    {
      label: '计划',
      prop: "planSnackStoreCnt",
    },
    {
      label: '执行',
      prop: "execSnackStoreCnt",
    },
    {
      label: '执行率',
      prop: "snackExecRate",
    }
  ]
}

// 三米两秒
export const getThreeTwoSecondsConfig = (submitChange) => {
  return [
    // {
    //   label: "计划月份",
    //   prop: "salesMonth",
    //   width: 100
    // },
    {
      label: "大区",
      prop: "regionName",
      width: 100
    },
    {
      label: "战区",
      prop: "districtName",
      width: 100
    },
    {
      label: "城市经理",
      prop: "cityManager",
      width: 100
    },
    {
      label: '计划',
      prop: "planSLStoreCnt",
    },
    {
      label: '执行',
      prop: "execSLStoreCnt",
    },
    {
      label: '执行率',
      prop: "SLExecRate",
    }
  ]
}

// 六小金刚
export const getSixLittleDiamondsConfig = (submitChange) => {
  return [
    // {
    //   label: "计划月份",
    //   prop: "salesMonth",
    //   width: 100
    // },
    {
      label: "大区",
      prop: "regionName",
      width: 100
    },
    {
      label: "战区",
      prop: "districtName",
      width: 100
    },
    {
      label: "城市经理",
      prop: "cityManager",
      width: 100
    },
    {
      label: '计划',
      prop: "planSixJdStoreCnt",
    },
    {
      label: '执行',
      prop: "execSixJdStoreCnt",
    },
    {
      label: '执行率',
      prop: "sixJdExecRate",
    }
  ]
}
