import path from 'path'
import pxtorem from 'postcss-pxtorem'
import { defineConfig, loadEnv } from 'vite'
import createVitePlugins from './vite/plugins'

export default defineConfig(({ mode, command }) => {
  const env = loadEnv(mode, process.cwd())
  const { VITE_APP_PUBLIC_PATH } = env
  return {
    base: VITE_APP_PUBLIC_PATH,
    plugins: createVitePlugins(env, command === 'build'),
    resolve: {
      alias: {
        '~': path.resolve(__dirname, './'),
        '@': path.resolve(__dirname, './src')
      },
      extensions: ['.mjs', '.js', '.ts', '.jsx', '.tsx', '.json', '.vue']
    },
    // vite 相关配置
    server: {
      port: 8085,
      host: true,
      open: true,
      proxy: {
        '/tencent_map_api': {
          target: 'https://apis.map.qq.com/ws/geocoder/v1',
          changeOrigin: true,
          rewrite: (p) => p.replace(/^\/tencent_map_api/, '')
        },
        '/dev-api': {
          target: 'http://192.168.100.55:8080',
          // target: 'https://sfa-qa.wxl66.cn/api',
          changeOrigin: true,
          rewrite: (p) => p.replace(/^\/dev-api/, '')
        },
        '/dev-promotion-api': {
          target: 'https://sfa-qa.wxl66.cn/promotion-api',
          changeOrigin: true,
          rewrite: (p) => p.replace(/^\/dev-promotion-api/, '')
        },
        '/ql_local': {
          target: 'http://192.168.131.48',
          changeOrigin: true,
          rewrite: (p) => p.replace(/^\/ql_local/, '')
        },
        '/bc_local': {
          target: 'http://192.168.100.180:8180',
          changeOrigin: true,
          rewrite: (p) => p.replace(/^\/bc_local/, '')
        }
      }
    },
    css: {
      postcss: {
        plugins: [
          {
            postcssPlugin: 'internal:charset-removal',
            AtRule: {
              charset: (atRule) => {
                if (atRule.name === 'charset') {
                  atRule.remove();
                }
              }
            },
          },
          pxtorem({
            rootValue: 37.5,
            propList: ['*'],
            exclude: file => {
              const dirList = ["vant", "mobile/views"]
              return !dirList.some(item => file.includes(item))
            }
          })
        ]
      }
    }
  }
})
