// 通过 JS 方式实现选择文件，而非组件
export const chooseFile = ({ accept, id = 'fileInput' }) => {
  return new Promise((resolve, reject) => {
    const fileInput = document.createElement('input')
    fileInput.type = 'file'
    fileInput.id = id
    fileInput.accept = accept
    fileInput.addEventListener('change', function () {
      if (fileInput.files.length > 0) {
        const file = fileInput.files[0]
        resolve(file)
      } else {
        reject('请选择文件')
      }
    })
    fileInput.addEventListener('change', () => {
      document.body.removeChild(fileInput)
    })
    // 关闭窗口没选择文件
    window.addEventListener('cancel', () => {
      document.body.removeChild(fileInput)
    })
    document.body.appendChild(fileInput)
    fileInput.click()
  })
}