import request from '@/utils/request'
// 管理员查询所有报表接口
export const selReportListAPI = (params) => {
  return request({
    url: `/report/jimuReport/query/all/list`,
    params
  })
}

// 授权单个报表给单个/多个用户
export const batchAuthReportAPI = (data) => {
  return request({
    url: `/report/jimuReportAuth/core/authUsers`,
    method: "PUT",
    data
  })
}

// 报表分类下拉列表接口
export const selReportCategoryAPI = () => {
  return request({
    url: `/report/jimuReportCategory/query/list`
  })
}

// 查询-报表已分配用户列表
export const selReportAuthUserListAPI = (params) => {
  return request({
    url: `/report/jimuReportAuth/query/list/user`,
    params
  })
}
