import request from '@/utils/request'

// 查询电商-店铺列表
export function listStore(query) {
  return request({
    url: '/bi/store/query/list',
    method: 'get',
    params: query
  })
}

// 新增电商-店铺
export function addStore(data) {
  return request({
    url: '/bi/store/core',
    method: 'post',
    data: data
  })
}

// 修改电商-店铺
export function updateStore(data) {
  return request({
    url: '/bi/store/core',
    method: 'put',
    data: data
  })
}

