import { createApp } from 'vue'
import App from './App'
import store from './store'
import router from './router'
import directive from './directive' // directive
import './permission' // permission control
import plugins from './plugins' // plugins
import { isMobile } from '@/utils'

/****************** 组件 ******************/
import ElementPlus from 'element-plus'
import 'element-plus/dist/index.css'
import 'element-plus/theme-chalk/dark/css-vars.css' // 暗黑模式变量
import locale from 'element-plus/es/locale/lang/zh-cn'
import '@/assets/styles/index.scss'

/****************** 插件 ******************/
import Cookies from 'js-cookie'
import 'virtual:svg-icons-register'  // svg 图标
import { download } from '@/utils/request'
import SvgIcon from '@/components/SvgIcon'
import elementIcons from '@/components/SvgIcon/svgicon'
import { useDict } from '@/utils/dict'
import { parseTime, resetForm, addDateRange, handleTree, selectDictLabel, selectDictLabels } from '@/utils'

// 分页
import Pagination from '@/components/Pagination'
// 表格工具
import RightToolbar from '@/components/RightToolbar'
// 富文本
import Editor from "@/components/Editor"
// 文件上传
import FileUpload from "@/components/FileUpload"
// 图片上传
import ImageUpload from "@/components/ImageUpload"
// 图片预览
import ImagePreview from "@/components/ImagePreview"
// 字典标签
import DictTag from '@/components/DictTag'
// 常用菜单
import CommonMenu from '@/components/CommonMenu'
// 悬浮工具球
import LevitatedSphere from '@/components/LevitatedSphere'
// 自定义图例
import GroupLegend from '@/components/ECharts/GroupLegend'
// 无数据占位
import NoData from '@/components/NoData'
// 树形类目
import CategoryTree from '@/components/CategoryTree'
// 返回头部
import BackToUp from '@/components/BackToUp'
// 自定义 toolTip
import XLToolTip from '@/components/XLToolTip'
// 自定义 select
import XlSelect from '@/components/XLSelect'
// 开窗查询组件
import OpenDialog from '@/components/OpenDialog'
// 只有在移动端引入 flexible.js
if (isMobile()) {
  (function () {
    const docEl = document.documentElement;
    const designWidth = 375; // 设计稿宽度（375px设计稿）
    const baseSize = 37.5;   // 与 postcss-pxtorem 的 rootValue 一致

    function setRem() {
      const scale = Math.min(docEl.clientWidth / designWidth, 2);
      docEl.style.setProperty('font-size', `${baseSize * scale}px`, 'important');
    }

    setRem();
    window.addEventListener('resize', setRem);
  })();
}

const app = createApp(App)

// 全局方法
app.config.globalProperties.useDict = useDict
app.config.globalProperties.download = download
app.config.globalProperties.parseTime = parseTime
app.config.globalProperties.resetForm = resetForm
app.config.globalProperties.handleTree = handleTree
app.config.globalProperties.addDateRange = addDateRange
app.config.globalProperties.selectDictLabel = selectDictLabel
app.config.globalProperties.selectDictLabels = selectDictLabels

// 全局组件
app.component('svg-icon', SvgIcon)
app.component('DictTag', DictTag)
app.component('Pagination', Pagination)
app.component('FileUpload', FileUpload)
app.component('ImageUpload', ImageUpload)
app.component('ImagePreview', ImagePreview)
app.component('RightToolbar', RightToolbar)
app.component('Editor', Editor)
app.component('CommonMenu', CommonMenu)
app.component('LevitatedSphere', LevitatedSphere)
app.component('GroupLegend', GroupLegend)
app.component('NoData', NoData)
app.component('CategoryTree', CategoryTree)
app.component('BackToUp', BackToUp)
app.component('XlToolTip', XLToolTip)
app.component('XlSelect', XlSelect)
app.component('OpenDialog', OpenDialog)

// 全局插件
app.use(plugins)
app.use(elementIcons)
app.use(ElementPlus, {
  locale: locale,
  size: Cookies.get('size') || 'default'
})
// 给 html 设置类名，用于影响自己的字体样式
document.documentElement.classList.add(Cookies.get('size') || 'default')

// 全局指令
directive(app)

// 路由和状态
app.use(router)
app.use(store)

app.mount('#app')
