// 移动端 静态路由
export const constantMobileRoutes = [
  {
    path: '/login',
    component: () => import('@/views/login'),
    hidden: true
  },
  {
    path: '/',
    redirect: '/m'
  },
  {
    path: '/m',
    redirect: '/m/menu',
    component: () => import('@/views/mobile/index'),
    hidden: true,
    children: [
      // 菜单页
      {
        path: 'menu',
        component: () => import('@/views/mobile/views/menu'),
        name: 'm_menu',
      },
      // 促销计划
      {
        path: 'promotion_plan', // 列表
        component: () => import('@/views/mobile/views/cp_activity/promotion/plan/index'),
        name: 'm_promotion_plan',
        meta: { keepAlive: true } // 标记该路由需要缓存
      },
      {
        path: 'promotion_plan_detail/:planId', // 详情
        component: () => import('@/views/mobile/views/cp_activity/promotion/plan/detail'),
        name: 'm_promotion_detail',
      },
      {
        path: 'promotion_plan_editing/:planId?', // 增改
        component: () => import('@/views/mobile/views/cp_activity/promotion/plan/editing'),
        name: 'm_promotion_editing',
      },
      // 稽查
      {
        path: 'examine/:examineId',
        component: () => import('@/views/mobile/views/cp_activity/examine'),
        name: 'm_promotion_examine',
      }
    ]
  },
  // 物流信息页面
  {
    path: '/logistics',
    component: () => import('@/views/mobile/views/other/logistics'),
    name: 'logistics'
  }
]