// 数学计算
// 除法函数，用来得到精确的除法结果
// 说明：javascript的除法结果会有误差，在两个浮点数相除的时候会比较明显。这个函数返回较为精确的除法结果。
// 调用：divSafe(arg1,arg2)
// 返回值：arg1除以arg2的精确结果
export function divSafe(arg1, arg2) {
  if (arg2 === 0 || arg2 === null) return 0; // 被除数为 0 直接返回 0
  var t1 = 0, t2 = 0, r1, r2;
  try {
    t1 = arg1.toString().split(".")[1].length;
  } catch (e) {
  }
  try {
    t2 = arg2.toString().split(".")[1].length;
  } catch (e) {
  }
  r1 = Number(arg1.toString().replace(".", ""));
  r2 = Number(arg2.toString().replace(".", ""));
  return (r1 / r2) * Math.pow(10, t2 - t1);
}

/**
 * 将数值转换为带单位的字符串，并添加千分位逗号
 * @param {object} 配置对象
    * @param {number} value - 要转换的数值
    * @param {bool}   carry - 是否开启亿万数量进位
    * @param {number} fixed - 保留几位小数
    * @param {bool}   round - 是否取整（四舍五入）
    * @param {bool}   pos   - 是否统一正数
    * @param {bool}   comma - 是否使用千分位逗号（从这里开始往下就是字符串了）
    * @param {string} des - 尾部额外添加描述字符（例如：人 / 元 / %等）
 * @returns {string} 格式化后的字符串
 */
export function formatNumberWithUnit({ value, carry = true, fixed = 2, round = true, pos = true, comma = true, des = '' }) {
  // console.log('传入', value, carry, fixed, round, pos, comma, des)
  let resultNum = 0 // 保存计算后的结果
  let unit = ''; // 保存转换后的单位（例如：万 / 亿）

  // 如果不是数字类型，先尝试转换
  if (typeof value === 'number' || !isNaN(value)) {
    value = Number(value);
  } else {
    return 0
  }

  // 如果 value 是空直接返回 0
  if (value === 0 || value === '' || value === null || value === undefined || isNaN(value)) {
    resultNum = 0
  }
  if (carry) {
    // 开启亿万数量进位
    if (value >= 100000000) {
      unit = '亿';
      resultNum = (value / 100000000);
    } else if (value >= 10000) {
      unit = '万';
      resultNum = (value / 10000);
    } else {
      unit = '';
      resultNum = value;
    }
  } else {
    resultNum = value
  }
  if (fixed) {
    // 保留几位小数
    resultNum = parseFloat(resultNum.toFixed(fixed));
    // console.log('保留小数', resultNum.toFixed(fixed), resultNum)
  }
  if (round) {
    // 是否取整
    resultNum = Math.round(resultNum)
    // console.log('取整', resultNum)
  }
  if (pos) {
    // 是否取整
    resultNum = Math.abs(resultNum);
  }
  if (comma) {
    // 将整数部分和小数部分分开
    const parts = resultNum.toString().split('.');
    // 只在整数部分添加逗号
    parts[0] = parts[0].replace(/\B(?=(\d{3})+(?!\d))/g, ',');
    // 重新组合整数部分和小数部分
    resultNum = parts.join('.');
  }
  return `${resultNum} ${unit}${des}`;
}

/**
 * 数值取最大完整数，最大位+1，其他位归 0
 * 例如：389234 位 400000
 */
export function roundUpToNextHighestPowerOfTen(num) {
  const first = num.toString()[0]
  const last = num.toString().substring(1)
  let result = ''
  for (let i = 0; i < last.length; i++) {
    result += '0'
  }
  return (Number(first) + 1) + result
}

// 保留 2 位小数
export function toFixed2(num) {
  if (num === null || num === undefined) return '0'
  return Number(num).toFixed(2)
}

/**
 * 随机生成 6 位数字和大写字母组合
 * @returns 
 */
export function randomCode() {
  const str = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'
  let code = ''
  for (let i = 0; i < 6; i++) {
    code += str.charAt(Math.floor(Math.random() * str.length))
  }
  return code
}