import request from '@/utils/request'
import { FS_APPID } from '@/config'

/****************** 飞书相关业务接口 ******************/
// 浏览器端授权飞书登录，回调地址 URL 上带回 code
export const fsOAuthUrl = `https://accounts.feishu.cn/open-apis/authen/v1/authorize?client_id=${FS_APPID}&state=fs&redirect_uri=${import.meta.env.VITE_APP_REDIRECT_URL}`

/**
 * 飞书客户端-静默授权获取 code
 * @returns {Promise}
 */
export function fsClientAuth() {
  return new Promise((resolve, reject) => {
    // 客户端内
    window.h5sdk.ready(async () => {
      if (window.tt?.requestAccess) {
        window.tt.requestAccess({
          scopeList: [],
          appID: FS_APPID,
          success: async ({ code }) => {
            resolve(code)
          }
        })
      }
    })
  })
}

/**
 * 飞书登录
 * @param {*} data { code: 授权码 } 
 * @returns 
 */
export function fsLogin(data) {
  return request({
    url: '/auth/fs/login',
    method: 'POST',
    data
  })
}

// 账号密码登录
export function login(data) {
  return request({
    url: '/auth/login',
    method: 'post',
    data
  })
}

// 获取用户详细信息
export function getInfo() {
  return request({
    url: '/system/user/getInfo'
  })
}

// 退出方法
export function logout() {
  return request({
    url: '/auth/logout',
    method: 'delete'
  })
}