// 获取文件扩展名
export function getFileTypeExt(url) {
  const fileName = url.split('/').pop()
  const fileType = fileName.split('.').pop()
  return fileType
}

// 判断 URL 是一个图片还是视频
function isImage(url) {
  const fileType = getFileTypeExt(url)
  return ['jpg', 'jpeg', 'png', 'gif', 'bmp'].includes(fileType.toLowerCase())
}
// 判断 URL 是一个视频
function isVideo(url) {
  const fileType = getFileTypeExt(url)
  return ['mp4', 'avi', 'mov', 'wmv', 'flv', '3gp', 'mkv', 'webm'].includes(fileType.toLowerCase())
}
// 来个统一出口
export function getMediaType(url) {
  if (isImage(url)) {
    return 'image'
  } else if (isVideo(url)) {
    return 'video'
  } else {
    return 'unknown'
  }
}
