import request from '@/utils/request'
const VITE_APP_PROMOTION = import.meta.env.VITE_APP_PROMOTION

// 获取计划列表
export function getPlanListAPI(queryParams) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: '/plan/v2/query/page',
    method: 'POST',
    data: {
      "pageNum": queryParams.pageNum,
      "pageSize": queryParams.pageSize,
      "queryParams": {
        "activityStartDate": queryParams.activityDate[0],
        "activityEndDate": queryParams.activityDate[1]
      }
    }
  })
}

// 表格新增计划（城市经理）
export function addPlanAPI(data) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: '/plan/v2/core/self/upload',
    method: 'POST',
    data
  })
}

// 表格新增计划（职能角色）
export function addPlanByRoleAPI(data) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: '/plan/v2/core/auth/upload',
    method: 'POST',
    data
  }) 
}


// 确认保存活动计划
export function savePlanAPI(uuid) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: `/plan/v2/core/upload/${uuid}`,
    method: 'GET'
  }) 
}


// 删除活动计划
export function deletePlanAPI(ids) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: `/plan/v2/core/delete`,
    method: 'DELETE',
    data: {
      planIds: ids
    }
  }) 
}