import request from '@/utils/request'
import OSS from 'ali-oss'
const ossAuthURL = `${import.meta.env.VITE_APP_PROMOTION}/user/aliyun/sts_token` // 后台获取阿里云 OSS 权限信息接口

// OSS 上传文件
export const uploadFileToOSSAPI = (fileName, filePath) => {
  return new Promise(async (resolve, reject) => {
    const authRes = await request({
      baseURL: ossAuthURL,
      url: '/'
    })
    const { accessKeyId, securityToken, accessKeySecret, expiration, region, web_js_link } = authRes.data;

    const client = new OSS({
      // Bucket 所在地域
      region: `oss-${region}`,
      // 从 STS 服务获取的临时访问密钥（AccessKey ID 和 AccessKey Secret）
      accessKeyId: accessKeyId,
      accessKeySecret: accessKeySecret,
      // 从STS服务获取的安全令牌（SecurityToken）。
      stsToken: securityToken,
      // 刷新临时访问凭证的时间间隔，单位为毫秒。
      refreshSTSTokenInterval: expiration,
      // 填写Bucket名称。
      bucket: web_js_link
    });

    // 发送请求上传文件 (文件名包含路径文件夹名字)
    const res = await client.put(fileName, filePath)
    resolve(res.url) // 上传成功

  })
}