import request from '@/utils/request';
// 获取-陈列计划列表
export function getDisplayList(params) {
  return request({
    url: '/operation/sales/ap_display/query/page',
    params
  })
}

// 填报-陈列计划
export function submitDisplayPlan(data) {
  // 遍历 data 每对 key value，发现 value 是 undefined 替换成空字符串
  Object.keys(data).forEach(key => {
    if (data[key] === undefined || data[key] === null) {
      data[key] = ''
    }
  })
  return request({
    url: `/operation/sales/ap_display/core/${data.id}`,
    method: 'PUT',
    data: {
      display: data
    }
  });
}

// 获取档期计划列表
export function getDisplayScheduleList(params) {
  return request({
    url: '/operation/sales/ap_promotion/query/page',
    params
  })
}

// 填报-档期计划
export function submitDisplaySchedulePlan(data) {
  Object.keys(data).forEach(key => {
    if (data[key] === undefined || data[key] === null) {
      data[key] = ''
    }
  })
  return request({
    url: `/operation/sales/ap_promotion/core/${data.id}`,
    method: 'PUT',
    data: {
      promotion: data
    }
  });
}
