import { parseTime } from '@/utils'
/**
 * 判断计划是否可变更/删除
 * @param {*} row 计划信息对象
 * @returns boolean true 可变更/删除，false 不可变更/删除
 */
export const checkPlanExpire = (row) => {
  // 1. 计划已经开始，不可变更/删除
  // 2. 计划未开始，但是上班时间已经 1 小时后，不可变更/删除
  const date = new Date()
  const rowDate = new Date(row.clockInTime)
  rowDate.setHours(rowDate.getHours() + 1)
  return !(rowDate < date || row.planStatus === 1)
}

/**
 * 判断计划是否可变更（单独判断按钮禁用状态）
 * 活动日期小于等于今日日期，则禁用变更按钮
 * @param {*} row 计划信息对象
 * @returns boolean true 可变更，false 不可变更
 */
export const checkPlanChangeExpire = (row) => {
  const date = new Date()
  const rowDate = new Date(row.date)
  console.log(date, row)
  return !(rowDate <= date)
}

/**
 * 判断任务是否可删除
 * @param {*} row 计划信息对象
 * @returns boolean true 展示删除按钮，false 不展示删除按钮
*/
export const checkTaskExpire = (row) => {
  // 上报日期不是当月则隐藏按钮
  const date = parseTime(row.createDate, '{y}-{m}')
  const currentDate = parseTime(new Date(), '{y}-{m}')
  return date === currentDate
}