import request from '@/utils/request'
import { parseTime } from '@/utils'
import { saveAs } from 'file-saver';


/**
 * 直播间列表
 * @returns 
 */
export const getBrandListAPI = () => {
  return request({
    url: '/bi/finance/zbjType/list'
  })
}

/**
 * 口味列表
 * @returns 
 */
export const getTasteListAPI = () => {
  return request({
    url: '/bi/finance/flavor/list'
  })
}

/**
 * 规格列表
 * @returns 
 */
export const getSpecListAPI = () => {
  return request({
    url: '/bi/finance/spec/list'
  })
}

/**
 * 获取财务列表
 * @param {*} data
 * @returns 
 */
export const getFinanceListAPI = (data) => {
  return request({
    url: '/bi/finance/cost/list',
    method: 'POST',
    data: {
      zbjQdType: data.zbjQdType,
      flavor: data.flavorErp,
      specName: data.specNameErp,
      zbjQdTypeAll: data.zbjQdTypeAll,
      flavorErpAll: data.flavorErpAll,
      specNameErpAll: data.specNameErpAll,
      series: data.seriesPrdMap.map(o => o[0]),
      goodsName: data.seriesPrdMap.map(o => o[1]),
      startDate: parseTime(data.date[0], `{y}-{m}-{d}`),
      endDate: parseTime(data.date[1], `{y}-{m}-{d}`),
      pageNum: data.pageNum,
      pageSize: data.pageSize
    }
  })
}

/**
 * 获取订单详情
 * @param {*} data 
 * @returns 
 */
export const getFinanceDetailAPI = (data) => {
  return request({
    url: '/bi/finance/cost/detail/list',
    method: 'POST',
    data: {
      zbjQdType: data.zbjQdType,
      flavor: data.flavorErp,
      specName: data.specNameErp,
      zbjQdTypeAll: data.zbjQdTypeAll,
      flavorErpAll: data.flavorErpAll,
      specNameErpAll: data.specNameErpAll,
      series: data.seriesPrdMap.map(o => o[0]),
      goodsName: data.seriesPrdMap.map(o => o[1]),
      startDate: parseTime(data.date[0], `{y}-{m}-{d}`),
      endDate: parseTime(data.date[1], `{y}-{m}-{d}`),
      pageNum: data.pageNum,
      pageSize: data.pageSize,
      // 直播间展开行里的订单详情需要带分销商（没有值参数也不会传递）
      fenxiaoId: data.fenxiaoId
    }
  })
}

/**
 * 直播间子数据列表
 * @param {*} data 
 * @returns 
 */
export const getFinanceSubListAPI = (data) => {
  console.log(data)
  return request({
    url: '/bi/finance/cost/subList',
    method: 'POST',
    data: {
      subType: 0, // 直播间的
      zbjQdType: data.zbjQdType instanceof Array ? data.zbjQdType : data.zbjQdType ? [data.zbjQdType] : [],
      flavor: data.flavorErp instanceof Array ? data.flavorErp : data.flavorErp ? [data.flavorErp] : [],
      specName: data.specNameErp instanceof Array ? data.specNameErp : data.specNameErp ? [data.specNameErp] : [],
      series: data.seriesPrdMap.map(o => o[0]),
      goodsName: data.seriesPrdMap.map(o => o[1]),
      startDate: parseTime(data.date[0], `{y}-{m}-{d}`),
      endDate: parseTime(data.date[1], `{y}-{m}-{d}`),
      pageNum: data.pageNum,
      pageSize: data.pageSize
    }
  })

}

/**
 * 下载数据表格
 */
export const downloadFinanceListAPI = async (data, fileName) => {
  const jsonString = JSON.stringify({
    zbjQdType: data.zbjQdType,
    flavor: data.flavorErp,
    specName: data.specNameErp,
    zbjQdTypeAll: data.zbjQdTypeAll,
    flavorErpAll: data.flavorErpAll,
    specNameErpAll: data.specNameErpAll,
    series: data.seriesPrdMap.map(o => o[0]),
    goodsName: data.seriesPrdMap.map(o => o[1]),
    startDate: parseTime(data.date[0], `{y}-{m}-{d}`),
    endDate: parseTime(data.date[1], `{y}-{m}-{d}`),
    subType: 0, // 代表直播间的展开数据
    type: data.type, // 0 代表导出达人数据，1 代表导出最外层所有数据，2 代表订单详情里的表格数据
  });

  const res = await request({
    url: '/bi/finance/cost/export',
    method: 'POST',
    responseType: 'blob',
    data: jsonString
  })
  // 保存文件到本地
  saveAs(res, fileName);
  
}
