import { defineConfig, loadEnv } from 'vite'
import path from 'path'
import createVitePlugins from './vite/plugins'

export default defineConfig(({ mode, command }) => {
  const env = loadEnv(mode, process.cwd())
  const { VITE_APP_PUBLIC_PATH } = env
  return {
    base: VITE_APP_PUBLIC_PATH,
    plugins: createVitePlugins(env, command === 'build'),
    resolve: {
      alias: {
        '~': path.resolve(__dirname, './'),
        '@': path.resolve(__dirname, './src')
      },
      extensions: ['.mjs', '.js', '.ts', '.jsx', '.tsx', '.json', '.vue']
    },
    // vite 相关配置
    server: {
      port: 8080,
      host: true,
      open: true,
      proxy: {
        '/dev-api': {
          target: 'http://192.168.100.39:8080',
          changeOrigin: true,
          rewrite: (p) => p.replace(/^\/dev-api/, '')
        },
        '/promotion-api': {
          target: 'http://192.168.100.39:8010',
          changeOrigin: true,
          rewrite: (p) => p.replace(/^\/promotion-api/, '')
        },
        '/ql_local': {
          target: 'http://192.168.131.48:8080',
          changeOrigin: true,
          rewrite: (p) => p.replace(/^\/ql_local/, '')
        }
      }
    },
    css: {
      postcss: {
        plugins: [
          {
            postcssPlugin: 'internal:charset-removal',
            AtRule: {
              charset: (atRule) => {
                if (atRule.name === 'charset') {
                  atRule.remove();
                }
              }
            }
          }
        ]
      }
    }
  }
})
