import request from '@/utils/request';
// 获取-陈列计划列表
export function getDisplayList(params) {
  return request({
    url: '/operation/sales/ap_display/query/page',
    params
  })
}

// 填报-陈列计划
export function submitDisplayPlan(data) {
  // 遍历 data 每对 key value，发现 value 是 undefined 替换成空字符串
  Object.keys(data).forEach(key => {
    if (data[key] === undefined || data[key] === null) {
      data[key] = ''
    }
  })
  return request({
    url: `/operation/sales/ap_display/core/${data.id}`,
    method: 'PUT',
    data: {
      display: {
        ...data,
        id: undefined // 不携带 id
      }
    }
  });
}

// 获取档期计划列表
export function getDisplayScheduleList(params) {
  return request({
    url: '/operation/sales/ap_promotion/query/page',
    params
  })
}

// 填报-档期计划
export function submitDisplaySchedulePlan(data) {
  Object.keys(data).forEach(key => {
    if (data[key] === undefined || data[key] === null) {
      data[key] = ''
    }
  })
  return request({
    url: `/operation/sales/ap_promotion/core/${data.id}`,
    method: 'PUT',
    data: {
      promotion: data
    }
  });
}

// 获取-档期陈列列表
export function getDisplayScheduleDetail(params) {
  return request({
    url: '/operation/sales/ap_display/query/pro_page',
    params
  })
}

// 填报-档期陈列
export function submitDisplayScheduleDetail(data) {
  Object.keys(data).forEach(key => {
    if (data[key] === undefined || data[key] === null) {
      data[key] = ''
    }
  })
  return request({
    url: `/operation/sales/ap_display/core_pro/${data.id}`,
    method: 'PUT',
    data: {
      promotionDisplay: {
        ...data,
        id: undefined // 不携带 id
      }
    }
  });
}

// 获取-零食计划列表
export function getSnackPlanList(params) {
  return request({
    url: '/operation/sales/ap_display/query/snack_page',
    params
  })
}

// 填报-零食计划
export function submitSnackPlan(data) {
  Object.keys(data).forEach(key => {
    if (data[key] === undefined || data[key] === null) {
      data[key] = ''
    }
  })
  return request({
    url: `/operation/sales/ap_display/core_snack/${data.id}`,
    method: 'PUT',
    data: {
      snackDisplay: {
        ...data,
        id: undefined // 不携带 id
      }
    }
  });
}

// 获取-三米两秒计划列表
export function getThreeMetersTwoSecondsPlanList(params) {
  return request({
    url: '/operation/sales/ap_display/query/sl_page',
    params
  })
}

// 获取-六小金刚计划列表
export function getSixLittleDiamondsPlanList(params) {
  return request({
    url: '/operation/sales/ap_display/query/jg_page',
    params
  })
}