import request from '@/utils/request'
const VITE_APP_PROMOTION = import.meta.env.VITE_APP_PROMOTION

// 获取计划列表
export function getPlanListAPI(queryParams) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: '/plan/v2/query/page',
    method: 'POST',
    data: {
      "pageNum": queryParams.pageNum,
      "pageSize": queryParams.pageSize,
      "queryParams": {
        "activityStartDate": queryParams.activityDate[0],
        "activityEndDate": queryParams.activityDate[1]
      }
    }
  })
}

// 表格新增计划
export function addPlanAPI(data) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: '/plan/v2/core/self/upload',
    method: 'POST',
    data
  })
}