import request from '@/utils/request';
// 获取-陈列计划列表
export function getDisplayList(params) {
  return request({
    url: '/operation/sales/ap_display/query/page',
    params
  })
}

// 填报-陈列计划
export function submitDisplayPlan(data) {
  return request({
    url: `/operation/sales/ap_display/core/${data.id}`,
    method: 'PUT',
    data: {
      display: data
    }
  });
}

// 获取档期计划列表
export function getDisplayScheduleList(params) {
  return request({
    url: '/operation/sales/ap_promotion/query/page',
    params
  })
}

// 填报-档期计划
export function submitDisplaySchedulePlan(data) {
  return request({
    url: `/operation/sales/ap_promotion/core/${data.id}`,
    method: 'PUT',
    data: {
      promotion: data
    }
  });
}
