
// 移动端 静态路由
export const constantMobileRoutes = [
  {
    path: '/login',
    component: () => import('@/views/login'),
    hidden: true
  },
  {
    path: '/m', // 勤策移动端内跳过来的地址是 /m，我们默认显示菜单页面
    redirect: '/menu'
  },
  {
    path: '/',
    component: () => import('@/views/mobile/index'),
    redirect: '/menu',
    children: [
      {
        path: 'menu',// 菜单页
        component: () => import('@/views/mobile/pages/menu'),
        name: 'm_menu'
      },
      {
        path: 'promotion_plan_detail/:planId', // 详情
        component: () => import('@/views/mobile/pages/cp_activity/promotion/plan/detail'),
        name: 'm_promotion_detail',
      },
      {
        path: 'promotion_plan_editing/:planId?', // 增改
        component: () => import('@/views/mobile/pages/cp_activity/promotion/plan/editing'),
        name: 'm_promotion_editing',
      },
      {
        path: 'examine/:examineId', // 促销内稽查
        component: () => import('@/views/mobile/pages/cp_activity/examine'),
        name: 'm_promotion_examine',
      },
      {
        path: 'logistics', // 物流信息页面
        component: () => import('@/views/mobile/pages/other/logistics'),
        name: 'logistics'
      }
    ]
  }
]