import request from '@/utils/request'

// 考勤规则-列表
export function listRule(query) {
  return request({
    url: '/system/kq_rule/list',
    method: 'get',
    params: query
  })
}

// 考勤规则-详细
export function getRule(ruleId) {
  return request({
    url: '/system/kq_rule/' + ruleId,
    method: 'get'
  })
}

// 新增考勤规则
export function addRule(data) {
  return request({
    url: '/system/kq_rule/add',
    method: 'post',
    data: data
  })
}

// 修改考勤规则
export function updateRule(data) {
  return request({
    url: '/system/kq_rule/put',
    method: 'put',
    data: data
  })
}

// 删除考勤规则
export function delRule(ruleId) {
  return request({
    url: '/system/kq_rule/' + ruleId,
    method: 'delete'
  })
}
