// 数学计算
// 除法函数，用来得到精确的除法结果
// 说明：javascript的除法结果会有误差，在两个浮点数相除的时候会比较明显。这个函数返回较为精确的除法结果。
// 调用：divSafe(arg1,arg2)
// 返回值：arg1除以arg2的精确结果
export function divSafe(arg1, arg2) {
  if (arg2 === 0 || arg2 === null) return 0; // 被除数为 0 直接返回 0
  var t1 = 0, t2 = 0, r1, r2;
  try {
    t1 = arg1.toString().split(".")[1].length;
  } catch (e) {
  }
  try {
    t2 = arg2.toString().split(".")[1].length;
  } catch (e) {
  }
  r1 = Number(arg1.toString().replace(".", ""));
  r2 = Number(arg2.toString().replace(".", ""));
  return (r1 / r2) * Math.pow(10, t2 - t1);
}

/**
 * 将数值转换为带单位的字符串，并添加千分位逗号
 * @param {number} value - 要转换的数值
 * @param {string} extraDescription - 额外的描述字符串（没有直接返回数据）
 * @param {bool} bool - 是否开启转换
 * @param {bool} round - 是否取整
 * @returns {string} 格式化后的字符串
 */
export function formatNumberWithUnit(value, extraDescription, bool, round) {
  // if (typeof value !== 'number') {
  //   throw new Error('输入值必须是数字');
  // }
  // 如果 value 是空直接返回 0
  if (value === 0 || value === '' || value === null || value === undefined) return 0;

  // 不转换
  if (!bool) {
    if(!round){
      if (!extraDescription) {
        return value.toFixed(2)
      } else {
        return value.toFixed(2) + extraDescription
      }
    }else{
      if (!extraDescription) {
        return Math.round(value) + ''
      } else {
        return Math.round(value) + extraDescription
      }
    }
  }

  // 转换单位
  let unit;
  let formattedValue;

  if (value >= 100000000) {
    unit = '亿';
    formattedValue = (value / 100000000);
  } else if (value >= 10000) {
    unit = '万';
    formattedValue = (value / 10000);
  } else {
    unit = '';
    formattedValue = value;
  }

  // 判断是否取整
  if (round) {
    formattedValue = Math.round(formattedValue) + '';
  } else {
    formattedValue = formattedValue.toFixed(2);
  }

  // 如果没有额外描述，直接返回数值
  if (!extraDescription) {
    return formattedValue;
  }

  // 添加千分位逗号
  formattedValue = formattedValue.replace(/\B(?=(\d{3})+(?!\d))/g, ',');

  return `${formattedValue}${unit}${extraDescription}`;
}

/**
 * 数值取最大完整数，最大位+1，其他位归 0
 * 例如：389234 位 400000
 */
export function roundUpToNextHighestPowerOfTen(num) {
  const first = num.toString()[0]
  const last = num.toString().substring(1)
  let result = ''
  for (let i = 0; i < last.length; i++) {
    result += '0'
  }
  return (Number(first) + 1) + result
}

// 保留 2 位小数
export function toFixed2(num) {
  if (num === null || num === undefined) return '0'
  return Number(num).toFixed(2)
}