// 封装从 URL 的查询参数找到要求的 key 对应的值
export function getQueryString(name) {
  const urlList = window.location.href.split('?').slice(1);
  const queryObj = {}
  urlList.forEach(item => {
    const list = item.split('&')
    list.forEach(o => {
      const [key, value] = o.split('=')
      queryObj[key] = value
    })
  })
  return queryObj[name] || ''
}

/**
 * 查询参数转对象
 * @param {string} url
 * @returns {Object}
 */
export function param2Obj(url = '?') {
  const search = decodeURIComponent(url.split('?')[1]).replace(/\+/g, ' ')
  if (!search) {
    return {}
  }
  const obj = {}
  const searchArr = search.split('&')
  searchArr.forEach(v => {
    const index = v.indexOf('=')
    if (index !== -1) {
      const name = v.substring(0, index)
      const val = v.substring(index + 1, v.length)
      obj[name] = val
    }
  })
  return obj
}