import fs from 'fs'

function parseChangelog(changelogText) {
  const result = {};
  const versionRegex = /^## \[([\d.]+)\]\([^)]+\)/; // 匹配二级标题版本
  const sectionRegex = /^### (.*?) \| (.*)$/; // 匹配三级标题部分
  const breakingChangesRegex = /^### ⚠ BREAKING CHANGES$/; // 匹配BREAKING CHANGES
  const descRegex = /^\* \*\*(.*?):?\*\* (.*?) \(/; // 匹配描述行

  let currentVersion = null;
  let currentSection = null;
  let isBreakingChanges = false;

  const lines = changelogText.split('\n');

  for (const line of lines) {
    // 检查是否是版本行 (二级标题)
    const versionMatch = line.match(versionRegex);
    if (versionMatch) {
      currentVersion = versionMatch[1];
      result[currentVersion] = {
        breakingChanges: [],
        changes: []
      };
      isBreakingChanges = false;
      continue;
    }

    // 如果是当前版本下的内容
    if (currentVersion) {
      // 检查是否是BREAKING CHANGES部分
      const breakingMatch = line.match(breakingChangesRegex);
      if (breakingMatch) {
        isBreakingChanges = true;
        continue;
      }

      // 检查是否是普通的三级标题部分
      const sectionMatch = line.match(sectionRegex);
      if (sectionMatch) {
        isBreakingChanges = false;
        currentSection = {
          type: sectionMatch[2], // 取 | 后面的部分作为类型
          desc: []
        };
        result[currentVersion].changes.push(currentSection);
        continue;
      }

      // 收集描述内容
      const descMatch = line.match(descRegex);
      if (descMatch) {
        const description = descMatch[2].trim();
        if (isBreakingChanges) {
          result[currentVersion].breakingChanges.push(description);
        } else if (currentSection) {
          currentSection.desc.push(description);
        }
      }
    }
  }

  return result;
}

const changelog = './CHANGELOG.md'
const changeData = fs.readFileSync(changelog, 'utf-8')
const result = parseChangelog(changeData)
// 把对象写回到 version.js 
console.log(result)