// 促销系统身份
export const CITY_MANAGER = 'cityManager' // 城市经理
export const FUNCTION_ROLE = 'functionRole' // 职能角色

const promotionRoles = {
  0: FUNCTION_ROLE, // 职能角色
  1: CITY_MANAGER // 城市经理
}
export const getPromotionRole = (role) => {
  return promotionRoles[role] || '未知身份'
}

// 促销活动状态
// 后台：返回数字，又让我传给他英文字符，页面展示中文
export const PROMOTION_STATUS = {
  0: {
    label: '未执行',
    value: 'NOT_EXECUTION'
  },
  1: {
    label: '执行',
    value: 'EXECUTION'
  }
}
export const getPromotionActiveStatus = (statusNum) => {
  return PROMOTION_STATUS[statusNum] || { label: '未知状态', value: '' }
}
