/**
 * 日期选项配置
 * @param {*} type 0：从今天开始往前，-1 则是 T - 1 开始日期往前
 * @returns {}
 */
export const useDatePickerOptions = (type = -1) => {
  const last30Date = [new Date().setDate((new Date().getDate() - (30 - 1))), new Date().setDate((new Date().getDate() + type))]
  const last7Date = [new Date().setDate((new Date().getDate() - (7 - 1))), new Date().setDate((new Date().getDate() + type))]
  const pickerOptions = ref([// 日期选项配置
    {
      text: '最近一周',
      value() {
        const end = new Date().setDate((new Date().getDate() + type));
        const start = new Date();
        start.setTime(start.getTime() - 3600 * 1000 * 24 * (7 - 1));
        return [start, end]
      }
    }, {
      text: '最近一个月',
      value() {
        const end = new Date().setDate((new Date().getDate() + type));
        const start = new Date();
        start.setTime(start.getTime() - 3600 * 1000 * 24 * (30 - 1));
        return [start, end]
      }
    }
  ])
  return {
    last30Date,
    last7Date,
    pickerOptions
  }
}