// 数学计算
// 除法函数，用来得到精确的除法结果
// 说明：javascript的除法结果会有误差，在两个浮点数相除的时候会比较明显。这个函数返回较为精确的除法结果。
// 调用：divSafe(arg1,arg2)
// 返回值：arg1除以arg2的精确结果
export function divSafe(arg1, arg2) {
  if (arg2 === 0 || arg2 === null) return 0; // 被除数为 0 直接返回 0
  var t1 = 0, t2 = 0, r1, r2;
  try {
    t1 = arg1.toString().split(".")[1].length;
  } catch (e) {
  }
  try {
    t2 = arg2.toString().split(".")[1].length;
  } catch (e) {
  }
  r1 = Number(arg1.toString().replace(".", ""));
  r2 = Number(arg2.toString().replace(".", ""));
  return (r1 / r2) * Math.pow(10, t2 - t1);
}

/**
 * 小数数字，转格式千分位用逗号，例如：12345.678 转换后 12,346
 * @param {*} num 
 * @returns 
 */
export function toThousands(num) {
  if (num === null || num === undefined) return '0'
  // 暂存小数位
  return (Math.round(num) || 0).toString().replace(/(\d)(?=(?:\d{3})+$)/g, '$1,')
}

/**
 * 数值取最大完整数，最大位+1，其他位归 0
 * 例如：389234 位 400000
 */
export function roundUpToNextHighestPowerOfTen(num) {
  const first = num.toString()[0]
  const last = num.toString().substring(1)
  let result = ''
  for (let i = 0; i < last.length; i++) {
    result += '0'
  }
  return (Number(first) + 1) + result
}

/**
 * 把数字转换成带元/万/亿单位结尾字符串
 * @param {*} number 
 * @param {*} isThousand 是否万分位数值（外面已经把数据除以万以后的数据）
 * @returns 
 */
export function convertToUnit(number, isThousand) {
  if (number === 0 || number === undefined || number === null) {
    return "0";
  }

  let unit;
  let value;

  if (isThousand) {
    number = number * 10000
  }
  if (number >= 100000000) {
    unit = " 亿元";
    value = number / 100000000;
  } else if (number >= 10000) {
    unit = " 万元";
    value = number / 10000;
  } else {
    unit = " 元";
    value = number;
  }

  // 保留两位小数
  let formattedValue = value.toFixed(2);

  // 去除末尾可能多余的0
  formattedValue = parseFloat(formattedValue).toString();

  return `${formattedValue}${unit}`;
}

// 保留 2 位小数
export function toFixed2(num) {
  if (num === null || num === undefined) return '0'
  return Number(num).toFixed(2)
}