
// 移动端 静态路由
export const constantMobileRoutes = [
  {
    path: '/index',
    redirect: '/menu'
  },
  {
    path: '/login',
    component: () => import('@/views/login'),
    hidden: true
  },
  {
    path: '/m', // 勤策移动端内跳过来的地址是 /m，我们默认显示菜单页面
    redirect: '/menu'
  },
  {
    path: '/',
    component: () => import('@/views/mobile/index'),
    redirect: '/menu',
    children: [
      {
        path: 'menu',// 菜单页
        component: () => import('@/views/mobile/pages/menu'),
        name: 'm_menu'
      },
      {
        path: 'promotion_plan_detail/:planId', // CP 促销计划，详情页
        component: () => import('@/views/mobile/pages/cp_activity/promotion/plan/detail'),
        name: 'm_promotion_detail',
      },
      {
        path: 'promotion_plan_editing/:planId?', // CP 促销计划，增加，修改
        component: () => import('@/views/mobile/pages/cp_activity/promotion/plan/editing'),
        name: 'm_promotion_editing',
      },
      {
        path: 'examine/:examineId', // CP 促销计划，稽查
        component: () => import('@/views/mobile/pages/cp_activity/examine'),
        name: 'm_promotion_examine',
      },
      {
        path: 'logistics', // 物流信息页面
        component: () => import('@/views/mobile/pages/other/logistics'),
        name: 'logistics'
      },
      {
        path: 'newTerminal', // 售点稽查_新建终端门店
        component: () => import('@/views/mobile/pages/audit_activity/sales_point_inspection/examine/newTerminal'),
        name: 'newTerminal'
      },
      {
        path: 'taskList', // 售点稽查_稽查记录列表
        component: () => import('@/views/mobile/pages/audit_activity/sales_point_inspection/examine/taskList'),
        name: 'taskList'
      },
      {
        path: 'inspectionTask', // 售点稽查_稽查任务
        component: () => import('@/views/mobile/pages/audit_activity/sales_point_inspection/examine/inspectionTask/index'),
        name: 'inspectionTask'
      },

    ]
  }
]