// 竞品店铺对应颜色
const BRAND_COLOR = {
  '三只松鼠': ['#5470c6', '#91cc75', '#fac858', '#ee6666'],
  '三只松鼠官方旗舰店直播间': ['#91cc75', '#fac858', '#5470c6', '#ee6666'],
  '百草味坚果旗舰店': ['#ee6666', '#fac858', '#5470c6', '#91cc75'],
  '百草味官方旗舰店': ['#73c0de', '#fac858', '#5470c6', '#91cc75'],

  '三只松鼠旗舰店': ['#fac858', '#73c0de', '#91cc75', '#5470c6'],
  '沃隆旗舰店': ['#3ba272', '#c23531', '#d15555', '#e69c9c'],
  '盐津铺子食品旗舰店': ['#fc8452', '#5470c6', '#91cc75', '#5470c6'],
  '藤桥官方旗舰店': ['#9a60b4', '#91cc75', '#5470c6', '#5470c6'],
  '好利来官方旗舰店': ['#ea7ccc', '#91cc75', '#5470c6', '#5470c6'],
  '炭食光食品旗舰店': ['#ff6699', '#91cc75', '#5470c6', '#5470c6'],
  '周黑鸭食品旗舰店': ['#cc66cc', '#91cc75', '#5470c6', '#5470c6'],
  '良品铺子旗舰店': ['#99cc00', '#91cc75', '#5470c6', '#5470c6'],
  '德芙官方旗舰店': ['#00cc99', '#91cc75', '#5470c6', '#5470c6'],
  '洽洽食品官方旗舰店': ['#cc0066', '#91cc75', '#5470c6', '#5470c6'],
  '蒙都旗舰店': ['#66ccff', '#91cc75', '#5470c6', '#5470c6'],
  '脱骨侠旗舰店': ['#ffcc00', '#91cc75', '#5470c6', '#5470c6'],
  '比比赞旗舰店': ['#0099cc', '#91cc75', '#5470c6', '#5470c6'],
}
/**
 * 通过直播间/店铺名字取出它的颜色数据
 * @param {*} brand 直播间店铺名字
 * @param {*} index 是取第几个颜色
 * @returns 16进制颜色
 */
export const getBrandColor = (brand, index = 0) => {
  if (BRAND_COLOR[brand]) {
    return BRAND_COLOR[brand][index]
  } else {
    return getRandomColor()
  }
}

// 生成 16 进制随机颜色
const getRandomColor = () => {
  let color = Math.floor(Math.random() * 16777215).toString(16);
  // 检查颜色字符串的长度，如果不足6位，则在前面补0
  while (color.length < 6) {
    color = '0' + color;
  }
  return '#' + color;
}

