import fs from 'fs'

function parseChangelog(changelogText) {
  const result = {};
  const versionRegex = /^### \[([\d.]+)\]\([^)]+\)/;
  const sectionRegex = /^### (.*?) \| (.*)$/;
  const descRegex = /^\* \*\*(.*?):?\*\* (.*?) \(/;

  let currentVersion = null;
  let currentSection = null;

  const lines = changelogText.split('\n');

  for (const line of lines) {
    // 检查是否是版本行
    const versionMatch = line.match(versionRegex);
    if (versionMatch) {
      currentVersion = versionMatch[1];
      result[currentVersion] = [];
      continue;
    }

    // 如果不是版本行但有当前版本，则检查是否是章节行
    if (currentVersion) {
      const sectionMatch = line.match(sectionRegex);
      if (sectionMatch) {
        currentSection = {
          info: sectionMatch[2],
          desc: []
        };
        result[currentVersion].push(currentSection);
        continue;
      }

      // 检查是否是描述行
      const descMatch = line.match(descRegex);
      if (descMatch && currentSection) {
        const description = descMatch[2].trim();
        currentSection.desc.push(description);
      }
    }
  }

  return result;
}

const changelog = './CHANGELOG.md'
const changeData = fs.readFileSync(changelog, 'utf-8')
const result = parseChangelog(changeData)
console.log(result)