/**
 * 生成时间列表
 * @param {*} startDate 起始时间
 * @param {*} endDate 终止时间
 * @returns [月-日，月-日，月-日]
 */
export function generatorDayList(startDate, endDate) {
  const dateArr = [];
  let currentDate = new Date(startDate);
  while (currentDate <= endDate) {
    dateArr.push(parseTime(currentDate, '{m}-{d}')); // 修改这一行，只取日期部分
    currentDate.setDate(currentDate.getDate() + 1);
  }
  return dateArr;
}
/**
 * 格式化时间，月日时分秒前面补零
 * @param {*} cellValue 时间
 * @returns "年-月-日 时:分:秒"
 */
export function formatDate(cellValue) {
  if (cellValue == null || cellValue == "") return "";
  var date = new Date(cellValue)
  var year = date.getFullYear()
  var month = date.getMonth() + 1 < 10 ? '0' + (date.getMonth() + 1) : date.getMonth() + 1
  var day = date.getDate() < 10 ? '0' + date.getDate() : date.getDate()
  var hours = date.getHours() < 10 ? '0' + date.getHours() : date.getHours()
  var minutes = date.getMinutes() < 10 ? '0' + date.getMinutes() : date.getMinutes()
  var seconds = date.getSeconds() < 10 ? '0' + date.getSeconds() : date.getSeconds()
  return year + '-' + month + '-' + day + ' ' + hours + ':' + minutes + ':' + seconds
}

/**
 * 计算时间多久之前
 * @param {number} time
 * @param {string} option
 * @returns {string}
 */
export function formatTime(time, option) {
  if (('' + time).length === 10) {
    time = parseInt(time) * 1000
  } else {
    time = +time
  }
  const d = new Date(time)
  const now = Date.now()

  const diff = (now - d) / 1000

  if (diff < 30) {
    return '刚刚'
  } else if (diff < 3600) {
    // less 1 hour
    return Math.ceil(diff / 60) + '分钟前'
  } else if (diff < 3600 * 24) {
    return Math.ceil(diff / 3600) + '小时前'
  } else if (diff < 3600 * 24 * 2) {
    return '1天前'
  }
  if (option) {
    return parseTime(time, option)
  } else {
    return (
      d.getMonth() +
      1 +
      '月' +
      d.getDate() +
      '日' +
      d.getHours() +
      '时' +
      d.getMinutes() +
      '分'
    )
  }
}

// 日期格式化
export function parseTime(time, pattern) {
  if (arguments.length === 0 || !time) {
    return null
  }
  const format = pattern || '{y}-{m}-{d} {h}:{i}:{s}'
  let date
  if (typeof time === 'object') {
    date = time
  } else {
    if ((typeof time === 'string') && (/^[0-9]+$/.test(time))) {
      time = parseInt(time)
    } else if (typeof time === 'string') {
      time = time.replace(new RegExp(/-/gm), '/').replace('T', ' ').replace(new RegExp(/\.[\d]{3}/gm), '');
    }
    if ((typeof time === 'number') && (time.toString().length === 10)) {
      time = time * 1000
    }
    date = new Date(time)
  }
  const formatObj = {
    y: date.getFullYear(),
    m: date.getMonth() + 1,
    d: date.getDate(),
    h: date.getHours(),
    i: date.getMinutes(),
    s: date.getSeconds(),
    a: date.getDay()
  }
  const time_str = format.replace(/{(y|m|d|h|i|s|a)+}/g, (result, key) => {
    let value = formatObj[key]
    // Note: getDay() returns 0 on Sunday
    if (key === 'a') { return ['日', '一', '二', '三', '四', '五', '六'][value] }
    if (result.length > 0 && value < 10) {
      value = '0' + value
    }
    return value || 0
  })
  return time_str
}

/**
 * 传入 "start" 获取 90 天前的时间戳，否则返回今天的年月日的日期对象（默认时间为 0 时 0 分 0 秒）
 * @param {string} type
 * @returns {Date}
 */
export function getTime(type) {
  if (type === 'start') {
    return new Date().getTime() - 3600 * 1000 * 24 * 90
  } else {
    return new Date(new Date().toDateString())
  }
}

/**
 * 时间后补 0 格式 例如：09:00 转成 09:00:00
 * @param {*} s 
 * @returns 
 */
export function timeAddZero(s) {
  if (s === null || s === '' || s === undefined) return s
  if (s.split(":").length === 3) return s
  return s + ':00'
}

/**
 * 时间去 0 格式,例如：09:00:00 转成 09:00
 * @param {*} s 
 * @returns 
 */
export function timeDelZero(s) {
  if (s === null || s === '' || s === undefined) return '00:00'
  if (s.split(":").length === 2) return s
  return s.split(":")[0] + ':' + s.split(":")[1]
}

/**
 * 判断开始时间小于指定时间范围
 * @param {*} startTime ["00:00:00", "02:00:00"] 时间数组
 * @param {*} endTime 单个要判断的时间
 * @returns 
 */
export function checkStartLessEndTime(startTime, endTime) {
  if (startTime === null || startTime?.length === 0 || endTime === null) return true
  // 把数组里的空值过滤掉
  const startTimeArr = startTime.filter(item => item)
  // 如果参数是 时:分:秒 格式则先转换处理
  return startTimeArr.every(timeStr => {
    const startDate = new Date()
    startDate.setHours(timeStr.split(":")[0])
    startDate.setMinutes(timeStr.split(":")[1])
    startDate.setSeconds(timeStr.split(":")[2])
    const endDate = new Date()
    endDate.setHours(endTime.split(":")[0])
    endDate.setMinutes(endTime.split(":")[1])
    endDate.setSeconds(endTime.split(":")[2])
    return startDate.getTime() - endDate.getTime() < 0
  })
}

/**
 * 把 00:00:00 转成 24:00:00
 * @param {*} time 
 * @returns 
 */
export const zeroTo24 = (time) => {
  if (time === '00:00:00') {
    return '24:00:00'
  } else {
    return time
  }
}

/**
 * 指定的日期范围添加到一个参数对象
 * @param {*} params 
 * @param {*} dateRange 
 * @param {*} propName 
 * @returns 
 */
export function addDateRange(params, dateRange, propName) {
  let search = params;
  search.params = typeof (search.params) === 'object' && search.params !== null && !Array.isArray(search.params) ? search.params : {};
  dateRange = Array.isArray(dateRange) ? dateRange : [];
  if (typeof (propName) === 'undefined') {
    search.params['beginTime'] = dateRange[0];
    search.params['endTime'] = dateRange[1];
    // 后端要求直接加到第一层上
    search.beginTime = dateRange[0];
    search.endTime = dateRange[1];
  } else {
    search.params['begin' + propName] = dateRange[0];
    search.params['end' + propName] = dateRange[1];
    // 后端要求直接加到第一层上
    search.begin = dateRange[0];
    search.end = dateRange[1];
  }

  return search;
}
