import request from '@/utils/request'
const VITE_APP_PROMOTION = import.meta.env.VITE_APP_PROMOTION

// 获取计划列表
export function getPlanListAPI(queryParams) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: '/plan/v2/query/page',
    method: 'POST',
    data: queryParams
  })
}

// 表格新增计划（城市经理）
export function addPlanAPI(data) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: '/plan/v2/core/self/upload',
    method: 'POST',
    data
  })
}

// 表格新增计划（职能角色）
export function addPlanByRoleAPI(data) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: '/plan/v2/core/auth/upload',
    method: 'POST',
    data
  })
}


// 确认保存活动计划
export function savePlanAPI(uuid) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: `/plan/v2/core/upload/${uuid}`,
    method: 'GET'
  })
}


// 删除活动计划
export function deletePlanAPI(data) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: `/plan/v2/core/delete`,
    method: 'DELETE',
    data
  })
}

// 经销商列表
export function getDealerListAPI(queryParams) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: '/user/dealer/query/list',
    params: {
      dealerName: queryParams.dealerName,
    }
  })
}

// web 页面创建单条活动计划
export function addPlanByWebAPI(data) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: '/plan/v2/core/save',
    method: 'POST',
    data
  })
}

// web 页面修改单条活动计划
export function updatePlanByWebAPI(data) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: '/plan/v2/core/one',
    method: 'PUT',
    data
  })
}

// 查询门店列表
export function getPlanStoreListAPI(data) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: '/user/clientele/query/store/list',
    method: 'POST',
    data
  })
}

// 表格-修改计划
export function updatePlanAPI(data) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: '/plan/v2/core/put',
    method: 'PUT',
    data
  })
}

// 批量修改计划归属人
export function batchUpdatePlanAPI(data) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: '/plan/v2/core/more',
    method: 'PUT',
    data
  })
}

// 查询计划详情（获取促销员打卡任务列表）
export function getPlanDetailAPI(id) {
  return request({
    baseURL: VITE_APP_PROMOTION,
    url: `/plan/v2/query/${id}`
  })
}