import { isMobile } from '@/utils'
// 移动端组件
// 选择搜索列表
import PickerSearch from './components/PickerSearch'
// 选择日期
import PickerCalendar from './components/PickerCalendar'
// 指令
import longPress from './directive/touch'
// 覆盖样式
import '@/assets/styles/vant.scss'

// 只有在移动端引入
if (isMobile()) {
  (function () {
    // flexible.js
    const docEl = document.documentElement;
    const designWidth = 375; // 设计稿宽度（375px设计稿）
    const baseSize = 37.5;   // 与 postcss-pxtorem 的 rootValue 一致

    function setRem() {
      const scale = Math.min(docEl.clientWidth / designWidth, 2);
      docEl.style.setProperty('font-size', `${baseSize * scale}px`, 'important');
    }

    setRem();
    window.addEventListener('resize', setRem);
  })();
}

export default function (app) {
  app.component('PickerSearch', PickerSearch);
  app.component('PickerCalendar', PickerCalendar);
  app.directive('longPress', longPress)
}