import { ElMessageBox } from 'element-plus'
import { parseTime } from '@/utils'

function splitAndFilter(str) {
  if (!str) return []
  // 分割字符串并处理空值
  return str?.split(/[,，]/)
    .map(item => item.trim()) // 去除前后空格
    .filter(item => item.length > 0); // 过滤空字符串
}
// 每个表格里的数据列信息集合
// 常规陈列
export const getDisplayConfig = (submitChange) => {
  return [
    // 一级类
    {
      label: "基础信息", // 类型标题
      children: [
        // {
        //   label: '操作提示',
        //   prop: 'operationTip', // 列属性
        //   visible: true, // 是否显示
        //   type: 'string', // 列类型
        //   fill: true, // 是否为填报列
        //   fixed: 'left', // 是否固定在左侧
        //   width: 100,
        //   onlyFill: true, // 只在填报列显示
        //   render: (_, row, col) => {
        //     return (
        //       <div class="operation_tip_cell">
        //         <p>计划</p>
        //         <p>实际</p>
        //       </div>
        //     )
        //   }
        // },
        {
          label: '计划月份', // 列标题
          prop: 'salesMonth', // 列属性
          visible: true, // 是否显示
          type: 'string', // 列类型
          fill: false, // 是否为填报列
          width: 100
        },
        {
          label: "销售大区",
          prop: "regionName",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "销售战区",
          prop: "districtName",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "经销商-省份",
          prop: "dealerProvince",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "经销商-城市",
          prop: "dealerCity",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "经销商-代码",
          prop: "dealerCode",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "经销商-类型",
          prop: "dealerType",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "开户日期",
          prop: "openingDate",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "闭户日期",
          prop: "closingDate",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "大区总监",
          prop: "regionManager",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "战区经理",
          prop: "districtManager",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "城市经理",
          prop: "cityManager",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        // {
        //   label: "门店名称",
        //   prop: "storeNameCodeDealerName", //新增动态列（只在填报列显示）
        //   visible: true,
        //   type: 'string',
        //   fill: true,
        //   onlyFill: true,// 仅仅在填报模式下生效
        //   fixed: 'left',
        //   width: 225,
        //   render: (h, row) => {
        //     return h('div', {
        //       class: 'store-name-render-cell'
        //     }, [
        //       h('p', row.storeName),
        //       h('p', row.storeCode),
        //       h('p', row.dealerName)
        //     ])
        //   }
        // },
        {
          label: "门店名称",
          prop: "storeName",
          visible: true,
          type: 'string',
          fill: true,
          fixed: 'left',
          width: 220
        },
        {
          label: "门店编码",
          prop: "storeCode",
          visible: true,
          type: 'string',
          fill: true,
          fixed: 'left',
          width: 110
        },
        {
          label: "经销商名称",
          prop: "dealerName",
          visible: true,
          type: 'string',
          fill: true,
          fixed: 'left',
          width: 220
        },
        {
          label: "系统类型",
          prop: "lineType",
          visible: true,
          type: 'string',
          fill: false,
          fixed: 'left',
          width: 100
        },
        {
          label: "门店-省份",
          prop: "storeProvince",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "门店-城市",
          prop: "storeCity",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "系统名称",
          prop: "lineName",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "渠道大类",
          prop: "channelDl",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "渠道小类",
          prop: "channelXl",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "门店类型",
          prop: "storeType",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "系统业态",
          prop: "systemFormat",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "门店面积",
          prop: "storeArea",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "门店分级（销量坎级）",
          prop: "storeLevel",
          visible: true,
          type: 'string',
          fill: false,
          width: 220
        },
        {
          label: "门店地址",
          prop: "storeAddress",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "品项数",
          prop: "productCount",
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        }
      ],
      prop: 'baseColumns',
      visible: true
    },
    {
      label: "大业态测试",
      children: [
        {
          label: "大业态测试-动销模型",
          prop: "lfSalesModel",
          visible: true,
          type: 'string',
          fill: false,
          width: 210
        },
        {
          label: "大业态测试-月均POS",
          prop: "lfMonthlyPos",
          visible: true,
          type: 'string',
          fill: false,
          width: 210
        }
      ],
      prop: 'lfColumns',
      visible: true
    },
    {
      label: "费用计划",
      prop: 'fpColumns',
      children: [
        {
          label: "主货架形式",
          subLabel: '计划',
          prop: "plannedMainShelfType",
          visible: true,
          type: 'string',
          fill: true,
          width: 130
        },

        {
          label: "主货架单个费用计划",
          prop: "plannedMainShelfUnitCost",
          visible: true,
          type: 'string',
          fill: false,
          width: 140
        },
        {
          label: "主货架总费用计划",
          prop: "plannedMainShelfTotalCost",
          visible: true,
          type: 'string',
          fill: false,
          width: 130
        },
        {
          label: "主货架形式",
          subLabel: '实际',
          prop: "actualMainShelfType",
          visible: true,
          type: 'select',
          options: [
            { label: '3纵', value: '3纵' },
            { label: '4纵', value: '4纵' },
            { label: '5纵', value: '5纵' },
            { label: '6纵', value: '6纵' },
            { label: '7纵', value: '7纵' },
            { label: '8纵及以上', value: '8纵及以上' }
          ],
          referenceKey: "plannedMainShelfType",
          fill: true,
          width: 130,
          render: (_, row, col, disabled) => {
            return (
              <div>
                {
                  row[col.referenceKey] ? <el-select modelValue={row[col.prop]}
                    onUpdate:modelValue={(value) => {
                      row[col.prop] = value;
                      submitChange(row, col);
                    }}
                    disabled={disabled}
                    class={{ 'no-disabled': row[col.referenceKey] }}
                    placeholder=""
                    clearable>
                    {col.options.map(item => (
                      <el-option
                        key={item.value}
                        label={item.label}
                        value={item.value}
                      />
                    ))}
                  </el-select> : '-'
                }
              </div>
            )
          },
          // 请求时需要额外携带影响的列字段值
          requestKey: ["actualMainShelfQty", "actualMainShelfExecuted", "regularDisplayExecuted"]
        },
        {
          label: "主货架数量",
          subLabel: '计划',
          prop: "plannedMainShelfQty",
          visible: true,
          type: 'string',
          fill: true,
          width: 130
        },
        {
          label: "主货架数量",
          subLabel: '实际',
          prop: "actualMainShelfQty",
          visible: true,
          type: 'input',
          referenceKey: "plannedMainShelfQty",
          fill: true,
          width: 130,
          render: (_, row, col, disabled) => {
            return (
              <div>
                {
                  row[col.referenceKey] ? <el-input modelValue={row[col.prop]}
                    onUpdate:modelValue={(value) => {
                      row[col.prop] = value;
                      submitChange(row, col);
                    }}
                    min="0"
                    type="number"
                    placeholder=""
                    disabled={disabled}
                    class={{ 'no-disabled': row[col.referenceKey], 'no-spinner': true, 'red-text': row[col.prop] > row[col.referenceKey] }}
                    clearable>
                  </el-input> : '-'
                }
              </div>
            )
          },
          requestKey: ["actualMainShelfExecuted", "regularDisplayExecuted"]
        },
        {
          label: "主货架是否",
          subLabel: '按计划执行',
          prop: "actualMainShelfExecuted",
          visible: true,
          type: 'formula',
          func: (row) => {
            if (parseInt(row.actualMainShelfType) < parseInt(row.plannedMainShelfType)) {
              // 主货架形式实际 < 主货架形式计划
              row.actualMainShelfExecuted = '未执行'
            } else if (!row.actualMainShelfQty) {
              // 主货架数量实际，未填写则未执行
              row.actualMainShelfExecuted = '未执行'
            } else if (parseInt(row.actualMainShelfQty) < parseInt(row.plannedMainShelfQty)) {
              // 主货架数量实际 < 主货架数量计划
              row.actualMainShelfExecuted = '未执行'
            } else {
              row.actualMainShelfExecuted = '执行'
            }
          },
          formulaStr: '公式：（主货架形式实际 >= 主货架形式计划）并且（主货架数量实际 >= 主货架数量计划）',
          fill: true,
          width: 130
        },
        {
          label: "端架数量",
          subLabel: '计划',
          prop: "plannedEndCapQty",
          visible: true,
          type: 'string',
          fill: true,
          width: 130
        },
        {
          label: "端架总费用计划",
          prop: "plannedEndCapTotalCost",
          visible: true,
          type: 'string',
          fill: false,
          width: 130
        },
        {
          label: "端架单个费用计划",
          prop: "plannedEndCapUnitCost",
          visible: true,
          type: 'string',
          fill: false,
          width: 130
        },
        {
          label: "端架数量",
          subLabel: '实际',
          prop: "actualEndCapQty",
          visible: true,
          type: 'select',
          options: [
            { label: '0', value: 0 },
            { label: '0.5', value: 0.5 },
            { label: '1', value: 1 },
            { label: '2', value: 2 }
          ],
          referenceKey: "plannedEndCapQty",
          fill: true,
          width: 130,
          render: (_, row, col, disabled) => {
            return (
              <div>
                {row[col.referenceKey] ? <el-select modelValue={row[col.prop]}
                  onUpdate:modelValue={(value) => {
                    row[col.prop] = value;
                    submitChange(row, col);
                  }}
                  disabled={disabled}
                  style={{ color: '#ff0000' }}
                  class={{ 'no-disabled': row[col.referenceKey], 'red-text': row[col.prop] > row[col.referenceKey] }}
                  placeholder=""
                  clearable>
                  {col.options.map(item => (
                    <el-option
                      key={item.value}
                      label={item.label}
                      value={item.value}
                    />
                  ))}
                </el-select> : '-'
                }
              </div>
            )
          },
          // 请求时需要额外携带影响的列字段值
          requestKey: ["actualEndCapExecuted", "regularDisplayExecuted"]
        },
        {
          label: "端架是否",
          subLabel: '按计划执行',
          prop: "actualEndCapExecuted",
          visible: true,
          type: 'formula',
          func: (row) => {
            row.actualEndCapExecuted = ((parseFloat(row.actualEndCapQty) >= parseFloat(row.plannedEndCapQty))) ? '执行' : '未执行'
          },
          formulaStr: '公式：（端架数量实际 >= 端架数量计划）',
          fill: true,
          width: 130
        },
        {
          label: "地堆平米数（㎡）",
          subLabel: '计划',
          prop: "plannedFloorStackArea",
          visible: true,
          type: 'string',
          fill: true,
          width: 130
        },

        {
          label: "主题地堆是否计划",
          prop: "plannedThemedFloorStack",
          visible: true,
          type: 'string',
          fill: false,
          width: 130
        },
        {
          label: "地堆总费用计划",
          prop: "plannedFloorStackTotalCost",
          visible: true,
          type: 'string',
          fill: false,
          width: 130
        },
        {
          label: "折算1㎡单个费用计划",
          prop: "plannedFloorStackUnitCostPerSqm",
          visible: true,
          type: 'string',
          fill: false,
          width: 130
        },
        {
          label: "地堆平米数（㎡）",
          subLabel: '实际',
          prop: "actualFloorStackArea",
          visible: true,
          type: 'select',
          options: [
            { label: '0', value: 0 },
            { label: '0.5', value: 0.5 },
            { label: '0.8', value: 0.8 },
            { label: '1', value: 1 },
            { label: '2', value: 2 },
            { label: '3', value: 3 },
            { label: '4', value: 4 },
            { label: '5', value: 5 },
            { label: '6', value: 6 },
            { label: '8', value: 8 },
          ],
          referenceKey: "plannedFloorStackArea",
          fill: true,
          width: 130,
          render: (_, row, col, disabled) => {
            return (
              <div>
                {row[col.referenceKey] ? <el-select modelValue={row[col.prop]}
                  onUpdate:modelValue={(value) => {
                    row[col.prop] = value;
                    submitChange(row, col);
                  }}
                  disabled={disabled}
                  class={{ 'no-disabled': row[col.referenceKey] }}
                  placeholder=""
                  clearable>
                  {col.options.map(item => (
                    <el-option
                      key={item.value}
                      label={item.label}
                      value={item.value}
                    />
                  ))}
                </el-select> : '-'}
              </div>
            )
          },
          // 请求时需要额外携带影响的列字段值
          requestKey: ["actualFloorStackExecuted", "regularDisplayExecuted"]
        },
        {
          label: "地堆数量",
          subLabel: '计划',
          prop: "plannedFloorStackQty",
          visible: true,
          type: 'string',
          fill: true,
          width: 130
        },
        {
          label: "地堆数量",
          subLabel: '实际',
          prop: "actualFloorStackQty",
          visible: true,
          type: 'select',
          options: [
            { label: '0', value: 0 },
            { label: '1', value: 1 },
            { label: '2', value: 2 },
            { label: '3', value: 3 },
            { label: '4', value: 4 },
            { label: '5', value: 5 }
          ],
          referenceKey: "plannedFloorStackQty",
          fill: true,
          width: 130,
          render: (_, row, col, disabled) => {
            return (
              <div>
                {row[col.referenceKey] ? <el-select modelValue={row[col.prop]}
                  onUpdate:modelValue={(value) => {
                    row[col.prop] = value;
                    submitChange(row, col);
                  }}
                  disabled={!row.actualFloorStackArea || disabled}
                  class={{ 'no-disabled': row.actualFloorStackArea && row[col.referenceKey], 'red-text': row[col.prop] > row[col.referenceKey] }}
                  placeholder=""
                  clearable>
                  {col.options.map(item => (
                    <el-option
                      key={item.value}
                      label={item.label}
                      value={item.value}
                    />
                  ))}
                </el-select> : '-'}
              </div>
            )
          },
          // 请求时需要额外携带影响的列字段值
          requestKey: ["actualFloorStackExecuted", "regularDisplayExecuted"]
        },
        // {
        //   label: "主题地堆是否实际",
        //   prop: "actualThemedFloorStack",
        //   referenceKey: "plannedThemedFloorStack",
        //   visible: true,
        //   type: 'select',
        //   options: [
        //     { label: '是', value: '是' },
        //     { label: '否', value: '否' }
        //   ],
        //   fill: false,
        //   width: 130,
        //   render: (_, row, col) => {
        //     return (
        //       <div>
        //         <span>{row[col.referenceKey] || '-'}</span>
        //         <el-select modelValue={row[col.prop]}
        //           onUpdate:modelValue={(value) => {
        //             row[col.prop] = value;
        //             submitChangeCallback(row, col);
        //           }}
        //           disabled={!row[col.referenceKey]}
        //           placeholder="">
        //           {col.options.map(item => (
        //             <el-option
        //               key={item.value}
        //               label={item.label}
        //               value={item.value}
        //             />
        //           ))}
        //         </el-select>
        //       </div>
        //     )
        //   }
        // },
        {
          label: "地堆是否",
          subLabel: '按计划执行',
          prop: "actualFloorStackExecuted",
          visible: true,
          type: 'formula',
          func: (row) => {
            row.actualFloorStackExecuted = ((parseFloat(row.actualFloorStackArea) >= parseFloat(row.plannedFloorStackArea)) && (parseInt(row.actualFloorStackQty) >= parseInt(row.plannedFloorStackQty))) ? '执行' : '未执行';
          },
          formulaStr: '公式：（地堆平米数实际 >= 地堆平米数计划）并且（地堆数量实际 >= 地堆数量计划）',
          fill: true,
          width: 130
        },
        {
          label: "多点陈列数量形式",
          subLabel: '计划',
          prop: "plannedMultiDisplay",
          visible: true,
          type: 'string',
          fill: true,
          width: 130
        },
        {
          label: "多点陈列总费用计划",
          prop: "plannedMultiDisplayTotalCost",
          visible: true,
          type: 'string',
          fill: false,
          width: 130
        },
        {
          label: "多点陈列数量形式",
          subLabel: '实际',
          prop: "actualMultiDisplay",
          visible: true,
          type: 'select',
          options: [
            { label: '执行与计划一致', value: '执行与计划一致' },
            { label: '执行与计划不一致', value: '执行与计划不一致' }
          ],
          referenceKey: "plannedMultiDisplay",
          fill: true,
          width: 190,
          render: (_, row, col, disabled) => {
            return (
              <div>
                {row[col.referenceKey] ? <el-select modelValue={row[col.prop]}
                  onUpdate:modelValue={(value) => {
                    row[col.prop] = value;
                    submitChange(row, col);
                  }}
                  disabled={disabled}
                  class={{ 'no-disabled': row[col.referenceKey] }}
                  placeholder=""
                  clearable>
                  {col.options.map(item => (
                    <el-option
                      key={item.value}
                      label={item.label}
                      value={item.value}
                    />
                  ))}
                </el-select> : '-'}
              </div>
            )
          },
          // 请求时需要额外携带影响的列字段值
          requestKey: ["actualMultiDisplayExecuted"]
        },
        {
          label: "多点陈列是否",
          subLabel: '按计划执行',
          prop: "actualMultiDisplayExecuted",
          referenceKey: 'actualMultiDisplay',
          visible: true,
          type: 'formula',
          func: (row) => {
            row.actualMultiDisplayExecuted = row.actualMultiDisplay === '执行与计划一致' ? '执行' : '未执行';
          },
          formulaStr: '公式：实际与计划是否一致',
          fill: true,
          width: 140,
        },
        {
          label: "挂条数量形式",
          subLabel: '计划',
          prop: "plannedHangingStripQuantityForm",
          visible: true,
          type: 'string',
          fill: true,
          width: 130
        },
        {
          label: "挂条数量形式",
          subLabel: '实际',
          prop: "actualHangingStripQuantityForm",
          visible: true,
          type: 'select',
          options: [
            { label: '执行与计划一致', value: '执行与计划一致' },
            { label: '执行与计划不一致', value: '执行与计划不一致' }
          ],
          referenceKey: "plannedHangingStripQuantityForm",
          fill: true,
          width: 190,
          render: (_, row, col, disabled) => {
            return (
              <div>
                {row[col.referenceKey] ? <el-select modelValue={row[col.prop]}
                  onUpdate:modelValue={(value) => {
                    row[col.prop] = value;
                    submitChange(row, col);
                  }}
                  disabled={disabled}
                  class={{ 'no-disabled': row[col.referenceKey] }}
                  placeholder=""
                  clearable>
                  {col.options.map(item => (
                    <el-option
                      key={item.value}
                      label={item.label}
                      value={item.value}
                    />
                  ))}
                </el-select> : '-'}
              </div>
            )
          },
          // 请求时需要额外携带影响的列字段值
          requestKey: ["hangingStripExecuted"]
        },
        {
          label: "挂条是否",
          subLabel: '按计划执行',
          prop: "hangingStripExecuted",
          visible: true,
          type: 'formula',
          func: (row) => {
            row.hangingStripExecuted = (row.actualHangingStripQuantityForm === '执行与计划一致') ? '执行' : '未执行';
          },
          formulaStr: '公式：实际与计划是否一致',
          fill: true,
          width: 130,
        },
        {
          label: "合计费用-费用",
          prop: "totalCost",
          visible: true,
          type: 'string',
          fill: false,
          width: 130
        },
        {
          label: "合计费用-费率",
          prop: "totalCostRate",
          visible: true,
          type: 'string',
          fill: false,
          width: 130
        },
        // {
        //   label: "常规陈列是否执行",
        //   prop: "regularDisplayExecuted",
        //   visible: true,
        //   type: 'formula',
        //   func: (row) => {
        //     // 实际主货架-执行 && 实际端架-执行 && 实际地堆-执行 && 实际多点陈列-执行
        //     // 过滤掉值为"-"的项，只对有实际值的项进行判断
        //     const executionStatuses = [
        //       row.actualMainShelfExecuted,
        //       row.actualEndCapExecuted,
        //       row.actualFloorStackExecuted,
        //       row.actualMultiDisplayExecuted
        //     ].filter(status => status !== '-');

        //     // 如果所有过滤后的状态都是'是'，则返回'执行'，否则返回'未执行'
        //     row.regularDisplayExecuted = executionStatuses.every(status => status === '是') ? '执行' : '未执行';
        //     return row.regularDisplayExecuted;
        //   },
        //   formulaStr: '公式：实际主货架执行，并且实际端架执行，并且实际地堆执行，并且实际多点陈列执行（某项无计划时，忽略该项）',
        //   fill: true,
        //   width: 150
        // },
        // {
        //   label: "综合标签-拜访辅助列",
        //   prop: "visitAssistTag",
        //   visible: true,
        //   type: 'string',
        //   fill: false,
        //   width: 160
        // },
        {
          label: "付费陈列-是否",
          prop: "paidDisplay",
          visible: true,
          type: 'string',
          fill: false,
          width: 130
        },
        {
          label: "当月拜访目标计划",
          prop: "monthlyVisitTarget",
          visible: true,
          type: 'string',
          fill: false,
          width: 130
        },
        {
          label: "当月是否拜访实际",
          prop: "monthlyVisited",
          visible: true,
          type: 'string',
          fill: false,
          width: 130
        },

        {
          label: '修改人',
          prop: 'updateBy',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '修改时间',
          prop: 'updateTime',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '备注',
          prop: 'remark',
          visible: true,
          type: 'input',
          fill: true,
          width: 150,
          render: (_, row, col, disabled) => {
            return (
              <div>
                {
                  <el-input modelValue={row[col.prop]}
                    onUpdate:modelValue={(value) => {
                      row[col.prop] = value;
                      submitChange(row, col);
                    }}
                    placeholder=""
                    disabled={disabled}
                    clearable>
                  </el-input>
                }
              </div>
            )
          },
        }
      ],
      visible: true
    }
  ]
}

// 档期计划
export const getSchedulePlanConfig = (submitChange) => {
  return [
    {
      label: "基础信息",
      children: [
        // {
        //   label: '操作提示',
        //   prop: 'operationTip', // 列属性
        //   visible: true, // 是否显示
        //   type: 'string', // 列类型
        //   fill: true, // 是否为填报列
        //   fixed: 'left', // 是否固定在左侧
        //   width: 100,
        //   onlyFill: true, // 只在填报列显示
        //   render: (_, row, col) => {
        //     return (
        //       <div class="operation_tip_cell">
        //         <p>计划</p>
        //         <p>实际</p>
        //       </div>
        //     )
        //   }
        // },
        {
          label: '计划月份',
          prop: 'salesMonth',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: "销售大区",
          prop: "regionName",
          visible: true,
          type: "string",
          fill: false,
          width: 100
        },
        {
          label: "销售战区",
          prop: "districtName",
          visible: true,
          type: "string",
          fill: false,
          width: 100
        },
        {
          label: "经销商-省份",
          prop: "dealerProvince",
          visible: true,
          type: "string",
          fill: false,
          width: 100
        },
        {
          label: "经销商-城市",
          prop: "dealerCity",
          visible: true,
          type: "string",
          fill: false,
          width: 100
        },
        {
          label: "经销商-代码",
          prop: "dealerCode",
          visible: true,
          type: "string",
          fill: false,
          width: 100
        },
        {
          label: "经销商名称",
          prop: "dealerName",
          visible: true,
          type: "string",
          fill: true,
          fixed: 'left',
          width: 200
        },
        {
          label: "经销商类型",
          prop: "dealerType",
          visible: true,
          type: "string",
          fill: false,
          width: 100
        },
        {
          label: "开户日期",
          prop: "openingDate",
          visible: true,
          type: "string",
          fill: false,
          width: 100
        },
        {
          label: "闭户日期",
          prop: "closingDate",
          visible: true,
          type: "string",
          fill: false,
          width: 100
        },
        {
          label: "大区总监",
          prop: "regionManager",
          visible: true,
          type: "string",
          fill: false,
          width: 100
        },
        {
          label: "战区经理",
          prop: "districtManager",
          visible: true,
          type: "string",
          fill: false,
          width: 100
        },
        {
          label: "城市经理",
          prop: "cityManager",
          visible: true,
          type: "string",
          fill: false,
          width: 100
        },
        {
          label: "系统名称",
          prop: "lineName",
          visible: true,
          type: "string",
          fill: true,
          fixed: 'left',
          width: 100
        },
        {
          label: "系统类型",
          prop: "lineType",
          visible: true,
          type: "string",
          fill: false,
          width: 100
        },
        {
          label: "渠道大类",
          prop: "channelDl",
          visible: true,
          type: "string",
          fill: false,
          width: 100
        },
        {
          label: "渠道小类",
          prop: "channelXl",
          visible: true,
          type: "string",
          fill: false,
          width: 100
        },
        {
          label: "系统业态",
          prop: "lineLf",
          visible: true,
          type: "string",
          fill: false,
          width: 100
        },
        {
          label: "门店数",
          prop: "storeCount",
          visible: true,
          type: "string",
          fill: false,
          width: 100
        }
      ],
      prop: 'baseColumns',
      visible: true
    },
    {
      label: "档期基础信息",
      children: [
        {
          label: "档期执行月份",
          prop: "promotionExecutionMonth",
          visible: true,
          type: "string",
          fill: false,
          width: 100
        },
        {
          label: "档期促销规格",
          subLabel: '计划',
          prop: "plannedPromotionSpec",
          visible: true,
          type: "string",
          fill: true,
          width: 150
        },
        {
          label: "档期促销规格",
          subLabel: '实际',
          prop: "actualPromotionSpec",
          visible: true,
          type: 'select',
          referenceKey: "plannedPromotionSpec",
          fill: true,
          width: 150,
          render: (_, row, col, disabled) => {
            let list = splitAndFilter(row[col.referenceKey])
            list = list.map(item => ({
              label: item,
              value: item
            })).concat([{
              label: '其他',
              value: '其他'
            }])
            return (
              <div>
                {row[col.referenceKey] ? <el-select modelValue={row[col.prop]}
                  onUpdate:modelValue={async (value) => {
                    row[col.prop] = value;
                    await submitChange(row, col);
                    col.checkFn(row)
                  }}
                  disabled={disabled}
                  class={{ 'no-disabled': row[col.referenceKey] }}
                  placeholder=""
                  clearable
                >
                  {list.map(item => (
                    <el-option
                      key={item.value}
                      label={item.label}
                      value={item.value}
                    />
                  ))}
                </el-select> : '-'}
              </div>
            )
          },
          checkFn(row) {
            // 检查点击选项并决定是否弹窗
            if (row.actualPromotionSpec && row.actualPromotionSpec.includes('其他')) {
              // 直接使用 ElMessageBox.prompt() 方法
              ElMessageBox.prompt('请输入实际执行规格', '提示', {
                confirmButtonText: '确定',
                cancelButtonText: '取消',
                inputType: 'textarea',
                inputPlaceholder: '请输入实际执行规格',
                // 可以设置输入框的行数
                inputValidator: (value) => {
                  if (!value || !value.trim()) {
                    return '请输入实际执行规格'
                  }
                  return true
                }
              }).then(({ value }) => {
                // 用户点击确定后，直接将输入的值赋予给 row 对象的指定属性
                row.actualPromotionSpecRe = value
                // 这里可以直接调用 submitChange 函数提交修改
                submitChange(row, { prop: 'actualPromotionSpecRe' })
              }).catch(() => {
                // 用户点击取消或关闭弹窗
              })
            } else {
              // 没选其他，则清空实际执行规格
              row.actualPromotionSpecRe = ''
              // 这里可以直接调用 submitChange 函数提交修改
              submitChange(row, { prop: 'actualPromotionSpecRe' })
            }
          },
          // 请求时需要额外携带影响的列字段值
          requestKey: ["specExecutionStatus", "promotionExecutionStatus"]
        },
        {
          label: "实际执行规格",
          prop: "actualPromotionSpecRe",
          visible: true,
          type: "input",
          render: (_, row, col, disabled) => {
            return (
              <div>
                {
                  row.actualPromotionSpec !== '其他' ? (<div style="width: 100%; text-align: center;">-</div>) : (
                    <el-input modelValue={row[col.prop]}
                      onUpdate:modelValue={(value) => {
                        row[col.prop] = value;
                        submitChange(row, col);
                      }}
                      disabled={disabled}
                      class='no-disabled'
                      placeholder=""
                      clearable>
                    </el-input>
                  )
                }
              </div>
            )
          },
          fill: true,
          width: 150
        },
        {
          label: "档期规格是否",
          subLabel: '按计划执行',
          prop: "specExecutionStatus",
          visible: true,
          type: 'formula',
          func: (row) => {
            row.specExecutionStatus = row.actualPromotionSpec === row.plannedPromotionSpec ? '执行' : '未执行';
          },
          formulaStr: '公式：（档期促销规格实际 = 档期促销规格计划）',
          fill: true,
          width: 150
        },
        {
          label: "档期促销口味",
          subLabel: '计划',
          prop: "plannedPromotionFlavor",
          visible: true,
          type: "string",
          fill: true,
          width: 150
        },
        {
          label: "档期促销口味",
          subLabel: '实际（可多选）',
          prop: "actualPromotionFlavor",
          visible: true,
          type: 'select',
          options: [],
          referenceKey: "plannedPromotionFlavor",
          fill: true,
          width: 170,
          render: (_, row, col, disabled) => {
            // options 根据参考属性值来决定（计划值）
            let list = splitAndFilter(row[col.referenceKey])
            let isFullFlavor = false
            // 如果数组里有"全系列"/"全口味"则修改数组
            if (list.includes('全口味')) {
              list = [
                {
                  label: '全口味',
                  value: '全口味'
                },
                {
                  label: '部分口味',
                  value: '部分口味'
                }
              ]
              isFullFlavor = true
            } else {
              list = list.map(item => ({
                label: item,
                value: item
              })).concat([{
                label: '其他',
                value: '其他'
              }])
              isFullFlavor = false
            }
            return (
              <div>
                {row[col.referenceKey] ? <el-select modelValue={row[col.prop]}
                  onUpdate:modelValue={async (value) => {
                    row[col.prop] = value;
                    await submitChange(row, col);
                    col.checkFn(row)
                  }}
                  disabled={disabled}
                  class={{ 'no-disabled': row[col.referenceKey] }}
                  placeholder=""
                  clearable
                  multiple={!isFullFlavor}
                  collapse-tags={!isFullFlavor}
                  collapse-tags-tooltip={!isFullFlavor}>
                  {list.map((item, index) => (
                    <el-option
                      key={index}
                      label={item.label}
                      value={item.value}
                    />
                  ))}
                </el-select> : '-'}

              </div >
            )
          },
          checkFn(row) {
            // 检查点击选项并决定是否弹窗
            if (row.actualPromotionFlavor && row.actualPromotionFlavor.includes('其他')) {
              // 直接使用 ElMessageBox.prompt() 方法
              ElMessageBox.prompt('请输入实际执行口味', '提示', {
                confirmButtonText: '确定',
                cancelButtonText: '取消',
                inputType: 'textarea',
                inputPlaceholder: '请输入实际执行口味',
                // 可以设置输入框的行数
                inputValidator: (value) => {
                  if (!value || !value.trim()) {
                    return '请输入实际执行口味'
                  }
                  return true
                }
              }).then(({ value }) => {
                // 用户点击确定后，直接将输入的值赋予给 row 对象的指定属性
                row.actualPromotionFlavorRe = value
                // 这里可以直接调用 submitChange 函数提交修改
                submitChange(row, { prop: 'actualPromotionFlavorRe' })
              }).catch(() => {
                // 用户点击取消或关闭弹窗
              })
            } else {
              // 没选其他，则清空实际执行口味
              row.actualPromotionFlavorRe = ''
              // 这里可以直接调用 submitChange 函数提交修改
              submitChange(row, { prop: 'actualPromotionFlavorRe' })
            }
          },
          // 请求时需要额外携带影响的列字段值
          requestKey: ["flavorExecutionStatus", "promotionExecutionStatus"]
        },
        {
          label: "实际执行口味",
          prop: "actualPromotionFlavorRe",
          visible: true,
          type: "input",
          render: (_, row, col, disabled) => {
            return (
              <div>
                {
                  row.actualPromotionFlavor.includes('其他') ? (
                    <el-input modelValue={row[col.prop]}
                      onUpdate:modelValue={(value) => {
                        row[col.prop] = value;
                        submitChange(row, col);
                      }}
                      disabled={disabled}
                      class='no-disabled'
                      placeholder=""
                      clearable>
                    </el-input>
                  ) : (<div style="width: 100%; text-align: center;">-</div>)
                }
              </div>
            )
          },
          fill: true,
          width: 150,
        },
        {
          label: "档期口味是否",
          subLabel: '按计划执行',
          prop: "flavorExecutionStatus",
          visible: true,
          type: 'formula',
          func: (row) => {
            // 处理逗号的口味形成数组
            let ppromotionFlavor = splitAndFilter(row.plannedPromotionFlavor)
            if (!row.actualPromotionFlavor) {
              // 判断空字符串
              row.flavorExecutionStatus = '未执行';
            } else if (row.actualPromotionFlavor?.length === 0) {
              // 空数组
              row.flavorExecutionStatus = '未执行';
            } else if (row.actualPromotionFlavor?.length === 1 && row.actualPromotionFlavor[0] === '其他') {
              // 数组里只有其他，则是未执行
              row.flavorExecutionStatus = '未执行';
            } else if (row.actualPromotionFlavor.includes('其他')) {
              // 数组里包含其他，就是未执行
              row.flavorExecutionStatus = '未执行';
            } else if (row.actualPromotionFlavor?.length !== ppromotionFlavor?.length) {
              // 计划的个数和实际选择的不一致，则也是未执行
              row.flavorExecutionStatus = '未执行';
            } else if (row.actualPromotionFlavor?.length === 1 && row.actualPromotionFlavor[0] === '全口味') {
              // 有且只有一个，并且是全口味，则执行
              row.flavorExecutionStatus = '执行';
            } else if (row.actualPromotionFlavor?.length === ppromotionFlavor.length && row.actualPromotionFlavor.every(item => ppromotionFlavor.includes(item))) {
              // 实际选项和计划选项数量一致
              row.flavorExecutionStatus = '执行';
            }
            return row.flavorExecutionStatus;
          },
          formulaStr: '公式：（档期促销口味执行 = 档期促销口味计划）',
          fill: true,
          width: 150,
        },
      ],
      prop: 'scheduleInfo',
      visible: true
    },
    {
      label: "合计费用",
      prop: 'totalCostParent',
      children: [
        {
          label: "合计费用",
          prop: "totalCost",
          visible: true,
          type: "string",
          fill: false,
          width: 105
        },
        {
          label: "合计费率",
          prop: "totalCostRate",
          visible: true,
          type: "string",
          fill: false,
          width: 85
        }
      ],
      visible: true
    },
    {
      label: "促销计划",
      prop: 'promotionPlan',
      children: [
        {
          label: "计划-档期形式",
          prop: "plannedPromotionFormat",
          visible: true,
          type: "string",
          fill: false,
          width: 115
        },
        {
          label: "计划-核销方式",
          prop: "plannedVerificationMethod",
          visible: true,
          type: "string",
          fill: false,
          width: 115
        },
        {
          label: "计划-档期规则",
          prop: "plannedPromotionRules",
          visible: true,
          type: "string",
          fill: false,
          width: 115
        },
        {
          label: "计划-档期前补差天数",
          prop: "plannedPrePromotionAdjustDays",
          visible: true,
          type: "string",
          fill: false,
          width: 155
        },
        {
          label: "计划-档期后补差天数",
          prop: "plannedPostPromotionAdjustDays",
          visible: true,
          type: "string",
          fill: false,
          width: 155
        },
        {
          label: "档期开始时间",
          subLabel: '计划',
          prop: "plannedPromotionStartDate",
          visible: true,
          type: "string",
          fill: true,
          width: 150
        },
        {
          label: "计划-补差开始时间",
          prop: "plannedAdjustmentStartDate",
          visible: true,
          type: "string",
          fill: false,
          width: 140
        },
        {
          label: "档期开始时间",
          subLabel: '实际',
          prop: "actualPromotionStartDate",
          visible: true,
          type: 'date',
          referenceKey: "plannedPromotionStartDate",
          fill: true,
          width: 150,
          render: (_, row, col, disabled) => {
            return (
              <div>
                {row[col.referenceKey] ? <div class={['date-picker', { 'no-disabled': row[col.referenceKey] }]}>
                  <el-date-picker modelValue={row[col.prop]}
                    onUpdate:modelValue={(value) => {
                      row[col.prop] = value;
                      submitChange(row, col);
                    }}
                    disabled={!row[col.referenceKey] || disabled}
                    placeholder=""
                    clearable
                    type="date"
                  />
                </div> : '-'}
              </div>
            )
          },
          requestKey: ["timeExecutionStatus", 'promotionImplementationStatus']
        },
        {
          label: "档期结束时间",
          subLabel: '计划',
          prop: "plannedPromotionEndDate",
          visible: true,
          type: "string",
          fill: true,
          width: 150,
        },
        {
          label: "计划-补差结束时间",
          prop: "plannedAdjustmentEndDate",
          visible: true,
          type: "string",
          fill: false,
          width: 140
        },
        {
          label: "档期结束时间",
          subLabel: '实际',
          prop: "actualPromotionEndDate",
          visible: true,
          type: 'date',
          fill: true,
          referenceKey: "plannedPromotionEndDate",
          width: 150,
          render: (_, row, col, disabled) => {
            return (
              <div>
                {row[col.referenceKey] ? <div class={['date-picker', { 'no-disabled': row[col.referenceKey] }]}>
                  <el-date-picker modelValue={row[col.prop]}
                    onUpdate:modelValue={(value) => {
                      row[col.prop] = value;
                      submitChange(row, col);
                    }}
                    disabled={!row[col.referenceKey] || disabled}
                    placeholder=""
                    clearable
                    type="date"
                  />
                </div> : '-'}
              </div>
            )
          },
          requestKey: ["timeExecutionStatus", 'promotionImplementationStatus']
        },
        {
          label: "档期是否",
          subLabel: '开展',
          prop: "promotionImplementationStatus",
          visible: true,
          type: 'formula',
          func: (row) => {
            row.promotionImplementationStatus = row.actualPromotionStartDate && row.actualPromotionEndDate ? '是' : '否';
            return row.promotionImplementationStatus;
          },
          formulaStr: '公式：（实际档期开始时间不为空，并且实际档期结束时间不为空）',
          fill: true,
          width: 150
        },
        // {
        //   label: "时间是否",
        //   subLabel: '按计划执行',
        //   prop: "timeExecutionStatus",
        //   visible: true,
        //   type: 'formula',
        //   func: (row) => {
        //     // 如果参考值是空则返回 '-'
        //     if (!row.plannedPromotionStartDate || !row.plannedPromotionEndDate) {
        //       row.timeExecutionStatus = '-';
        //       return '-';
        //     }
        //     row.timeExecutionStatus = (parseTime(row.actualPromotionStartDate) === parseTime(row.plannedPromotionStartDate)) && parseTime(row.actualPromotionEndDate) === parseTime(row.plannedPromotionEndDate) ? '执行' : '未执行';
        //     return row.timeExecutionStatus;
        //   },
        //   formulaStr: '公式：（实际档期开始时间 = 计划档期开始时间，并且实际档期结束时间 = 计划档期结束时间）',
        //   fill: true,
        //   width: 150
        // },
        {
          label: "促销机制",
          subLabel: '计划',
          prop: "plannedPromotionMechanism",
          visible: true,
          type: "string",
          fill: true,
          width: 150
        },
        {
          label: "促销售价",
          subLabel: '计划',
          prop: "plannedPromotionPrice",
          visible: true,
          type: "string",
          fill: true,
          width: 150
        },
        // {
        //   label: "促销机制",
        //   subLabel: '实际',
        //   prop: "actualPromotionMechanism",
        //   visible: true,
        //   type: 'select',
        //   referenceKey: "plannedPromotionMechanism",
        //   fill: true,
        //   width: 190,
        //   options: [
        //     {
        //       label: '执行与计划一致',
        //       value: '执行与计划一致'
        //     },
        //     {
        //       label: '执行与计划不一致',
        //       value: '执行与计划不一致'
        //     }
        //   ],
        //   render: (_, row, col) => {
        //     return (
        //       <div>
        //         {/* <span>{row[col.referenceKey] || '-'}</span> */}
        //         <div style="width: 100%">
        //           <el-select modelValue={row[col.prop]}
        //             onUpdate:modelValue={async (value) => {
        //               row[col.prop] = value;
        //               await submitChange(row, col);
        //               col.checkFn(row)
        //             }}
        //             disabled={!row[col.referenceKey]}
        //             class={{ 'no-disabled': row[col.referenceKey] }}
        //             placeholder=""
        //             clearable
        //           >
        //             {col.options.map(item => (
        //               <el-option key={item.value} label={item.label} value={item.value} />
        //             ))}
        //           </el-select>
        //         </div>
        //       </div>
        //     )
        //   },
        //   checkFn(row) {
        //     // 检查点击选项并决定是否弹窗
        //     if (row.actualPromotionMechanism === '执行与计划不一致') {
        //       // 直接使用 ElMessageBox.prompt() 方法
        //       ElMessageBox.prompt('请输入实际执行价格', '提示', {
        //         confirmButtonText: '确定',
        //         cancelButtonText: '取消',
        //         inputType: 'textarea',
        //         inputPlaceholder: '请输入实际执行价格',
        //         // 可以设置输入框的行数
        //         inputValidator: (value) => {
        //           if (!value || !value.trim()) {
        //             return '请输入实际执行价格'
        //           }
        //           return true
        //         }
        //       }).then(({ value }) => {
        //         // 用户点击确定后，直接将输入的值赋予给 row 对象的指定属性
        //         row.actualPromotionPriceRe = value
        //         // 这里可以直接调用 submitChange 函数提交修改
        //         submitChange(row, { prop: 'actualPromotionPriceRe' })
        //       }).catch(() => {
        //         // 用户点击取消或关闭弹窗
        //       })
        //     } else {
        //       // 没选其他，则清空实际执行价格
        //       row.actualPromotionPriceRe = ''
        //       // 这里可以直接调用 submitChange 函数提交修改
        //       submitChange(row, { prop: 'actualPromotionPriceRe' })
        //     }
        //   }
        // },
        {
          label: "执行价格",
          subLabel: '实际',
          prop: "actualPromotionPriceRe",
          referenceKey: "plannedPromotionMechanism", // 促销机制计划
          visible: true,
          type: "input",
          options: [
            {
              label: '买赠',
              value: '买赠'
            },
            {
              label: '其他',
              value: '其他'
            }
          ],
          render: (_, row, col, disabled) => {
            return (
              <div>
                {
                  row.plannedPromotionMechanism ? (row.plannedPromotionMechanism?.includes('赠') ? (<el-select modelValue={row[col.prop]}
                    onUpdate:modelValue={(value) => {
                      row[col.prop] = value;
                      submitChange(row, col);
                    }}
                    disabled={disabled}
                    class='no-disabled'
                    placeholder=""
                    clearable
                  >
                    {col.options.map(item => (
                      <el-option key={item.value} label={item.label} value={item.value} />
                    ))}
                  </el-select>) : (
                    <el-input modelValue={row[col.prop]}
                      onUpdate:modelValue={(value) => {
                        // 只能输入数字
                        row[col.prop] = value;
                        submitChange(row, col);
                      }}
                      disabled={disabled}
                      class={{ 'no-disabled': true, 'no-spinner': true, 'red-text': row[col.prop] > row.plannedPromotionPrice }}
                      placeholder=""
                      type="number"
                      min="0"
                      clearable>
                    </el-input>
                  )) : '-'
                }
              </div>
            )
          },
          fill: true,
          width: 150,
          requestKey: ["promotionPriceExecutionStatus"]
        },
        // {
        //   label: "促销机制是否执行",
        //   prop: "promotionMechanismExecutionStatus",
        //   visible: true,
        //   type: 'formula',
        //   func: (row) => {
        //     // 如果参考值是空则返回 '-'
        //     if (!row.plannedPromotionMechanism) {
        //       row.promotionMechanismExecutionStatus = '-';
        //       return '-';
        //     }
        //     row.promotionMechanismExecutionStatus = row.actualPromotionMechanism === '执行与计划一致' ? '执行' : '未执行';
        //     return row.promotionMechanismExecutionStatus;
        //   },
        //   formulaStr: '公式：实际促销机制，是否有值',
        //   fill: true,
        //   width: 150,
        // },
        {
          label: "预估袋数",
          prop: "estimatedBagCount",
          visible: true,
          type: "string",
          fill: false,
          width: 90
        },
        // {
        //   label: "档期备货量（袋）",
        //   prop: "promotionStockQuantity",
        //   visible: true,
        //   type: 'input',
        //   format: 'number',
        //   referenceKey: "estimatedBagCount",
        //   fill: true,
        //   width: 135,
        //   render: (_, row, col) => {
        //     return (
        //       <div>
        //         <span>{row[col.referenceKey] || '-'}</span>
        //         <div>
        //           <el-input modelValue={row[col.prop]}
        //             onUpdate:modelValue={(value) => {
        //               row[col.prop] = value;
        //               submitChange(row, col);
        //             }}
        //             disabled={!row[col.referenceKey]}
        //             placeholder=""
        //             clearable
        //           />
        //         </div>
        //       </div>
        //     )
        //   }
        // },
        {
          label: "单包厂价（单包）",
          prop: "unitFactoryPrice",
          visible: true,
          type: "string",
          fill: false,
          width: 135
        },
        {
          label: "正常供价（单包）",
          prop: "normalSupplyPrice",
          visible: true,
          type: "string",
          fill: false,
          width: 135
        },
        {
          label: "日常零售价（单包）",
          prop: "regularRetailPrice",
          visible: true,
          type: "string",
          fill: false,
          width: 150
        },
        {
          label: "计划促销售价（单包）",
          prop: "plannedPromotionPrice",
          visible: true,
          type: "string",
          fill: false,
          width: 165
        },
        // {
        //   label: "实际促销售价（单包）",
        //   prop: "actualPromotionPrice",
        //   visible: true,
        //   type: 'input',
        //   format: 'number',
        //   referenceKey: "plannedPromotionPrice",
        //   fill: true,
        //   width: 165,
        //   render: (_, row, col) => {
        //     return (
        //       <div>
        //         <span>{row[col.referenceKey] || '-'}</span>
        //         <div>
        //           <el-input modelValue={row[col.prop]}
        //             onUpdate:modelValue={(value) => {
        //               row[col.prop] = value;
        //               submitChange(row, col);
        //             }}
        //             disabled={!row[col.referenceKey]}
        //             placeholder=""
        //             clearable
        //           />
        //         </div>
        //       </div>
        //     )
        //   },
        //   requestKey: ["promotionPriceExecutionStatus"]
        // },
        {
          label: "促销价是否",
          subLabel: '按计划执行',
          prop: "promotionPriceExecutionStatus",
          visible: true,
          type: 'formula',
          func: (row) => {
            if (row.actualPromotionPriceRe === '买赠') {
              row.promotionPriceExecutionStatus = '执行'
            } else if (row.actualPromotionPriceRe) {
              row.promotionPriceExecutionStatus = (row.actualPromotionPriceRe * 1 <= row.plannedPromotionPrice * 1) ? '执行' : '未执行'
            } else {
              row.promotionPriceExecutionStatus = '未执行'
            }
          },
          formulaStr: '公式：（促销机制计划带"赠"则选择买赠） 或 （执行促销售价实际 <= 促销售价计划）为执行否则未执行',
          fill: true,
          width: 150
        },
        {
          label: "正常经销商毛利现状",
          prop: "normalDealerMarginStatus",
          visible: true,
          type: "string",
          fill: false,
          width: 150
        },
        {
          label: "系统前台毛利保证",
          prop: "systemFrontendMarginGuarantee",
          visible: true,
          type: "string",
          fill: false,
          width: 135
        },
        {
          label: "系统后台毛利保证",
          prop: "systemBackendMarginGuarantee",
          visible: true,
          type: "string",
          fill: false,
          width: 135
        },
        {
          label: "系统促销毛利保证",
          prop: "systemPromotionMarginGuarantee",
          visible: true,
          type: "string",
          fill: false,
          width: 135
        },
        {
          label: "经销商毛利保证",
          prop: "dealerMarginGuarantee",
          visible: true,
          type: "string",
          fill: false,
          width: 125
        },
        {
          label: "单袋补差金额（费用）",
          prop: "unitBagAdjustmentAmount",
          visible: true,
          type: "string",
          fill: false,
          width: 165
        },
        {
          label: "补差费比（%）",
          prop: "adjustmentCostRatio",
          visible: true,
          type: "string",
          fill: false,
          width: 125
        },
        {
          label: "整体补差（费用）",
          prop: "totalAdjustmentCost",
          visible: true,
          type: "string",
          fill: false,
          width: 135
        },
        // {
        //   label: "档期是否执行",
        //   prop: "promotionExecutionStatus",
        //   visible: true,
        //   type: 'formula',
        //   func: (row) => {
        //     // 过滤掉值为"-"的项，只对有实际值的项进行判断
        //     const executionStatuses = [
        //       row.promotionPriceExecutionStatus,
        //       row.promotionMechanismExecutionStatus,
        //       row.specExecutionStatus,
        //       row.promotionImplementationStatus
        //     ].filter(status => status !== '-');

        //     // 如果所有过滤后的状态都是'是'，则返回'是'，否则返回'否'
        //     row.promotionExecutionStatus = executionStatuses.every(status => status === '是') ? '执行' : '未执行';
        //     return row.promotionExecutionStatus;
        //   },
        //   formulaStr: '公式：促销价执行，并且促销口味执行，并且促销规格执行，并且档期开展（某项无计划时，忽略该项）',
        //   fill: true,
        //   width: 125
        // }
      ],
      visible: true
    },
    {
      label: "海报计划",
      prop: 'posterPlan',
      children: [
        {
          label: "海报形式",
          subLabel: '计划',
          prop: "plannedPosterFormat",
          visible: true,
          type: "string",
          fill: true,
          width: 150
        },
        {
          label: "计划-海报费用",
          prop: "plannedPosterCost",
          visible: true,
          type: "string",
          fill: false,
          width: 115
        },
        {
          label: "海报形式",
          subLabel: '实际',
          prop: "actualPosterFormat",
          visible: true,
          type: 'select',
          options: [
            {
              label: '插卡',
              value: '插卡'
            },
            {
              label: '厂商周',
              value: '厂商周'
            },
            {
              label: '电子',
              value: '电子'
            },
            {
              label: '海报',
              value: '海报'
            },
            {
              label: '跳卡',
              value: '跳卡'
            },
            {
              label: '纸质',
              value: '纸质'
            }
          ],
          referenceKey: "plannedPosterFormat",
          fill: true,
          width: 150,
          render: (_, row, col, disabled) => {
            return (
              <div>
                <div style="width: 100%">
                  {row[col.referenceKey] ? <el-select modelValue={row[col.prop]}
                    onUpdate:modelValue={(value) => {
                      row[col.prop] = value;
                      submitChange(row, col);
                    }}
                    disabled={disabled}
                    class={{ 'no-disabled': row[col.referenceKey] }}
                    placeholder=""
                    clearable
                  >
                    {col.options.map(item => (
                      <el-option key={item.value} label={item.label} value={item.value} />
                    ))}
                  </el-select> : '-'}
                </div>
              </div>
            )
          },
          requestKey: ["posterExecutionStatus"]
        },
        {
          label: "海报是否",
          subLabel: '按计划执行',
          prop: "posterExecutionStatus",
          visible: true,
          type: 'formula',
          func: (row) => {
            row.posterExecutionStatus = row.plannedPosterFormat == row.actualPosterFormat ? '执行' : '未执行';
          },
          formulaStr: '公式：（实际海报形式 = 计划海报形式）',
          fill: true,
          width: 150
        }
      ],
      visible: true
    },
    {
      label: "档期陈列",
      prop: 'displayPlan',
      children: [
        {
          label: "门店数",
          prop: "storeCountInt",
          visible: true,
          type: "string",
          fill: false,
          width: 75
        },
        {
          label: "店均费用",
          prop: "averageStoreCost",
          visible: true,
          type: "string",
          fill: false,
          width: 115
        },
        {
          label: "费用",
          prop: "cost",
          visible: true,
          type: "string",
          fill: false,
          width: 115
        },
        {
          label: '修改人',
          prop: 'updateBy',
          visible: true,
          type: 'string',
          fill: false,
          width: 120
        },
        {
          label: '修改时间',
          prop: 'updateTime',
          visible: true,
          type: 'string',
          fill: false,
          width: 180
        },
        {
          label: '备注',
          prop: 'remark',
          visible: true,
          type: 'input',
          fill: true,
          width: 150,
          render: (_, row, col, disabled) => {
            return (
              <div>
                {
                  <el-input modelValue={row[col.prop]}
                    onUpdate:modelValue={(value) => {
                      row[col.prop] = value;
                      submitChange(row, col);
                    }}
                    placeholder=""
                    disabled={disabled}
                    clearable>
                  </el-input>
                }
              </div>
            )
          },
        }
      ],
      visible: true
    }
  ]
}

// 档期陈列
export const getScheduleDisConfig = (submitChange) => {
  return [
    // 一级类
    {
      label: "基础信息", // 类型标题（用于右上角控制显隐列）
      children: [
        // {
        //   label: '操作提示', // 列标题
        //   prop: 'operationTip', // 列属性
        //   visible: true, // 是否显示
        //   type: 'string', // 列类型
        //   fill: true, // 是否在填报模式显示
        //   fixed: 'left', // 是否固定在左侧
        //   width: 100, // 列宽度
        //   onlyFill: true, // 只在填报列显示（展示模式不显示）
        //   render: (_, row, col) => { // 列自定义渲染内容
        //     return (
        //       <div class="operation_tip_cell">
        //         <p>计划</p>
        //         <p>实际</p>
        //       </div>
        //     )
        //   }
        // },
        {
          label: '计划月份', // 列标题
          prop: 'salesMonth', // 列属性
          visible: true, // 是否显示
          type: 'string', // 列类型
          fill: false, // 是否为填报列
          width: 100
        },
        {
          "label": "销售大区",
          "prop": "regionName",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 90
        },
        {
          "label": "销售战区",
          "prop": "districtName",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 90
        },
        {
          "label": "经销商 - 省份",
          "prop": "dealerProvince",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 110
        },
        {
          "label": "经销商 - 城市",
          "prop": "dealerCity",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 110
        },
        {
          "label": "经销商 - 代码",
          "prop": "dealerCode",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 110
        },
        {
          "label": "经销商名称",
          "prop": "dealerName",
          "visible": true,
          "type": "string",
          "fill": true,
          "width": 200,
          fixed: 'left'
        },
        // {
        //   "label": "经销商类型",
        //   "prop": "dealerType",
        //   "visible": true,
        //   "type": "string",
        //   "fill": false,
        //   "width": 150
        // },
        // {
        //   "label": "开户日期",
        //   "prop": "openingDate",
        //   "visible": true,
        //   "type": "string",
        //   "fill": false,
        //   "width": 120
        // },
        // {
        //   "label": "闭户日期",
        //   "prop": "closingDate",
        //   "visible": true,
        //   "type": "string",
        //   "fill": false,
        //   "width": 120
        // },
        {
          "label": "大区总监",
          "prop": "regionManager",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 80
        },
        {
          "label": "战区经理",
          "prop": "districtManager",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 80
        },
        {
          "label": "城市经理",
          "prop": "cityManager",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 80
        },
        {
          "label": "系统名称",
          "prop": "lineName",
          "visible": true,
          "type": "string",
          "fill": true,
          "width": 100,
          fixed: 'left'
        },
        {
          "label": "系统类型",
          "prop": "lineType",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 110
        },
        {
          "label": "渠道大类",
          "prop": "channelDl",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 100
        },
        {
          "label": "渠道小类",
          "prop": "channelXl",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 150
        },
        {
          "label": "系统业态",
          "prop": "lineLf",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 120
        },
        {
          "label": "门店数",
          "prop": "storeCount",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 90
        }
      ],
      prop: 'baseColumns',
      visible: true
    },
    // {
    //   label: "档期基础信息",
    //   children: [
    //     {
    //       "label": "档期执行月份",
    //       "prop": "promotionExecutionMonth",
    //       "visible": true,
    //       "type": "string",
    //       "fill": false,
    //       "width": 120
    //     },
    //     {
    //       "label": "档期计划 - 促销规格",
    //       "prop": "plannedPromotionSpec",
    //       "visible": true,
    //       "type": "string",
    //       "fill": false,
    //       "width": 160
    //     },
    //     {
    //       "label": "档期计划 - 促销口味",
    //       "prop": "plannedPromotionFlavor",
    //       "visible": true,
    //       "type": "string",
    //       "fill": false,
    //       "width": 160
    //     }
    //   ],
    //   prop: 'scheduleBaseColumns',
    //   visible: true
    // },
    // {
    //   label: "促销计划",
    //   prop: 'scheduleFpColumns',
    //   children: [
    //     {
    //       "label": "计划 - 档期规则",
    //       "prop": "plannedPromotionRules",
    //       "visible": true,
    //       "type": "string",
    //       "fill": false,
    //       "width": 140
    //     },
    //     {
    //       "label": "计划 - 档期前补差天数",
    //       "prop": "plannedPrePromotionAdjustDays",
    //       "visible": true,
    //       "type": "string",
    //       "fill": false,
    //       "width": 160
    //     },
    //     {
    //       "label": "计划 - 档期后补差天数",
    //       "prop": "plannedPostPromotionAdjustDays",
    //       "visible": true,
    //       "type": "string",
    //       "fill": false,
    //       "width": 160
    //     },
    //     {
    //       "label": "计划 - 档期开始时间",
    //       "prop": "plannedPromotionStartDate",
    //       "visible": true,
    //       "type": "string",
    //       "fill": false,
    //       "width": 160
    //     },
    //     {
    //       "label": "计划 - 补差开始时间",
    //       "prop": "plannedAdjustmentStartDate",
    //       "visible": true,
    //       "type": "string",
    //       "fill": false,
    //       "width": 160
    //     },
    //     {
    //       "label": "计划 - 档期结束时间",
    //       "prop": "plannedPromotionEndDate",
    //       "visible": true,
    //       "type": "string",
    //       "fill": false,
    //       "width": 160
    //     },
    //     {
    //       "label": "计划 - 补差结束时间",
    //       "prop": "plannedAdjustmentEndDate",
    //       "visible": true,
    //       "type": "string",
    //       "fill": false,
    //       "width": 160
    //     }
    //   ],
    //   visible: true
    // },
    {
      label: '档期门店陈列计划',
      prop: 'scheduleStoreColumns',
      children: [
        {
          "label": "计划 - 档期陈列开始时间",
          "prop": "plannedPromotionDisplayStartDate",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 180
        },
        {
          "label": "计划 - 档期陈列结束时间",
          "prop": "plannedPromotionDisplayEndDate",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 180
        },
        {
          "label": "门店编码",
          "prop": "storeCode",
          "visible": true,
          "type": "string",
          "fill": true,
          "width": 120,
          fixed: 'left'
        },
        {
          "label": "门店名称",
          "prop": "storeName",
          "visible": true,
          "type": "string",
          "fill": true,
          "width": 170,
          fixed: 'left'
        },
        {
          "label": "门店类型",
          "prop": "storeType",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 80
        },
        {
          "label": "门店计数",
          "prop": "storeCountNum",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 80
        },
        // {
        //   "label": "门店地址",
        //   "prop": "storeAddress",
        //   "visible": true,
        //   "type": "string",
        //   "fill": false,
        //   "width": 280
        // },
        {
          "label": "端架数量",
          "subLabel": '计划',
          "prop": "plannedEndCapQty",
          "visible": true,
          "type": "string",
          "fill": true,
          "width": 140
        },
        // {
        //   "label": "计划端架 - 费用",
        //   "prop": "plannedEndCapTotalCost",
        //   "visible": true,
        //   "type": "string",
        //   "fill": false,
        //   "width": 140
        // },
        {
          "label": "端架数量",
          "subLabel": '实际',
          "prop": "actualEndCapQty",
          "visible": true,
          "type": "select",
          referenceKey: "plannedEndCapQty",
          "options": [
            {
              "label": "0",
              "value": 0
            },
            {
              "label": "0.5",
              "value": 0.5
            },
            {
              "label": "1",
              "value": 1
            },
            {
              "label": "2",
              "value": 2
            }
          ],
          render: (_, row, col, disabled) => {
            return (
              <div>
                {row[col.referenceKey] ? <el-select modelValue={row[col.prop]}
                  onUpdate:modelValue={(value) => {
                    row[col.prop] = value;
                    submitChange(row, col);
                  }}
                  disabled={disabled}
                  class={{ 'no-disabled': row[col.referenceKey] }}
                  placeholder=""
                  clearable>
                  {col.options.map(item => (
                    <el-option
                      key={item.value}
                      label={item.label}
                      value={item.value}
                    />
                  ))}
                </el-select> : '-'}
              </div>
            )
          },
          "fill": true,
          "width": 140,
          requestKey: ["actualEndCapExecuted", "promotionDisplayExecuted"]
        },
        {
          "label": "端架是否",
          "subLabel": '按计划执行',
          "prop": "actualEndCapExecuted",
          "visible": true,
          "type": "formula",
          "fill": true,
          "width": 140,
          func: (row) => {
            row.actualEndCapExecuted = row.actualEndCapQty * 1 >= row.plannedEndCapQty * 1 ? '执行' : '未执行'
            return row.actualEndCapExecuted
          },
          formulaStr: "端架数量执行 >= 端架数量计划"
        },
        {
          "label": "地堆平米数（㎡）",
          "subLabel": '计划',
          "prop": "plannedFloorStackArea",
          "visible": true,
          "type": "string",
          "fill": true,
          "width": 140
        },

        // {
        //   "label": "计划地堆 - 费用",
        //   "prop": "plannedFloorStackTotalCost",
        //   "visible": true,
        //   "type": "string",
        //   "fill": false,
        //   "width": 140
        // },
        {
          "label": "地堆平米数（㎡）",
          "subLabel": '实际',
          "prop": "actualFloorStackArea",
          "visible": true,
          "type": "input",
          "fill": true,
          "width": 140,
          referenceKey: "plannedFloorStackArea",
          options: [
            { label: '0', value: 0 },
            { label: '0.5', value: 0.5 },
            { label: '0.8', value: 0.8 },
            { label: '1', value: 1 },
            { label: '2', value: 2 },
            { label: '3', value: 3 },
            { label: '4', value: 4 },
            { label: '5', value: 5 },
            { label: '6', value: 6 },
            { label: '8', value: 8 },
          ],
          render: (_, row, col, disabled) => {
            return (
              <div>
                {row[col.referenceKey] ? <el-select modelValue={row[col.prop]}
                  onUpdate:modelValue={(value) => {
                    row[col.prop] = value;
                    submitChange(row, col);
                  }}
                  disabled={disabled}
                  class={{ 'no-disabled': row[col.referenceKey] }}
                  placeholder=""
                  clearable>
                  {col.options.map(item => (
                    <el-option
                      key={item.value}
                      label={item.label}
                      value={item.value}
                    />
                  ))}
                </el-select> : '-'}
              </div>
            )
          },
          requestKey: ["actualFloorStackExecuted", "promotionDisplayExecuted"]
        },
        {
          "label": "地堆数量",
          "subLabel": '计划',
          "prop": "plannedFloorStackQty",
          "visible": true,
          "type": "string",
          "fill": true,
          "width": 140
        },
        {
          "label": "地堆数量",
          "subLabel": '实际',
          "prop": "actualFloorStackQty",
          "visible": true,
          "type": "input",
          "fill": true,
          "width": 140,
          referenceKey: "plannedFloorStackQty",
          // "options": [
          //   {
          //     "label": "0",
          //     "value": 0
          //   },
          //   {
          //     "label": "1",
          //     "value": 1
          //   },
          //   {
          //     "label": "2",
          //     "value": 2
          //   },
          //   {
          //     "label": "3",
          //     "value": 3
          //   },
          //   {
          //     "label": "4",
          //     "value": 4
          //   }

          // ],
          render: (_, row, col, disabled) => {
            return (
              <div>
                {row[col.referenceKey] ? <el-input modelValue={row[col.prop]}
                  onUpdate:modelValue={(value) => {
                    row[col.prop] = value;
                    submitChange(row, col);
                  }}
                  disabled={!row[col.referenceKey] || disabled}
                  class={{ 'no-disabled': row[col.referenceKey], 'no-spinner': true, 'red-text': row[col.prop] > row[col.referenceKey] }}
                  min="0"
                  type="number"
                  placeholder=""
                  clearable>
                </el-input> : '-'}

              </div>
            )
          },
          requestKey: ["actualFloorStackExecuted", "promotionDisplayExecuted"]
        },
        {
          "label": "地堆是否",
          "subLabel": '按计划执行',
          "prop": "actualFloorStackExecuted",
          "visible": true,
          "type": "formula",
          "fill": true,
          "width": 140,
          func: (row) => {
            row.actualFloorStackExecuted = row.actualFloorStackArea >= row.plannedFloorStackArea && row.actualFloorStackQty >= row.plannedFloorStackQty ? '执行' : '未执行'
            return row.actualFloorStackExecuted
          },
          formulaStr: "地堆平米数实际 >= 地堆平米数计划，并且 地堆数量实际 >= 地堆数量计划"
        },
        {
          "label": "其他陈列数量+形式",
          "subLabel": '计划',
          "prop": "plannedOtherDisplay",
          "visible": true,
          "type": "string",
          "fill": true,
          "width": 140
        },
        // {
        //   "label": "计划其他陈列 - 总费用",
        //   "prop": "plannedOtherDisplayTotalCost",
        //   "visible": true,
        //   "type": "string",
        //   "fill": false,
        //   "width": 160
        // },
        {
          "label": "其他陈列数量+形式",
          "subLabel": '实际',
          "prop": "actualOtherDisplay",
          "visible": true,
          "type": "select",
          "options": [
            { label: '执行与计划一致', value: '执行与计划一致' },
            { label: '执行与计划不一致', value: '执行与计划不一致' }
          ],
          "fill": true,
          "width": 190,
          referenceKey: "plannedOtherDisplay",
          render: (_, row, col, disabled) => {
            return (
              <div>
                {row[col.referenceKey] ? <el-select modelValue={row[col.prop]}
                  onUpdate:modelValue={(value) => {
                    row[col.prop] = value;
                    submitChange(row, col);
                  }}
                  disabled={disabled}
                  class={{ 'no-disabled': row[col.referenceKey] }}
                  placeholder=""
                  clearable
                >
                  {col.options.map(item => (
                    <el-option
                      key={item.value}
                      label={item.label}
                      value={item.value}
                    />
                  ))}
                </el-select> : '-'}
              </div>
            )
          },
          requestKey: ["actualOtherDisplayExecuted", "promotionDisplayExecuted"]
        },
        {
          "label": "其他陈列是否",
          "subLabel": '按计划执行',
          "prop": "actualOtherDisplayExecuted",
          "visible": true,
          "type": "formula",
          "fill": true,
          "width": 140,
          func: (row) => {
            row.actualOtherDisplayExecuted = row.actualOtherDisplay === '执行与计划一致' ? '执行' : '未执行'
            return row.actualOtherDisplayExecuted
          },
          formulaStr: "公式：实际与计划是否一致"
        },
        {
          "label": "合计费用 - 费用",
          "prop": "totalCost",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 140
        },
        // {
        //   "label": "档期陈列是否执行",
        //   "prop": "promotionDisplayExecuted",
        //   "visible": true,
        //   "type": "formula",
        //   "fill": true,
        //   "width": 160,
        //   func: (row) => {
        //     // 实际端架-是否执行 && 实际地堆是否执行 && 实际其他陈列-是否执行
        //     const executionStatuses = [
        //       row.actualEndCapExecuted,
        //       row.actualFloorStackExecuted,
        //       row.actualOtherDisplayExecuted
        //     ].filter(status => status !== '-');

        //     // 如果所有过滤后的状态都是'是'，则返回'是'，否则返回'否'
        //     row.promotionDisplayExecuted = executionStatuses.every(status => status === '是') ? '执行' : '未执行';
        //     return row.promotionDisplayExecuted;
        //   },
        //   formulaStr: "公式：实际端架执行，并且实际地堆执行，并且实际其他陈列执行（某项无计划时，忽略该项）"
        // },
        {
          "label": "付费陈列 - 是否",
          "prop": "paidDisplay",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 120
        },
        {
          "label": "当月拜访目标 - 是否",
          "prop": "monthlyVisitTarget",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 160
        },
        {
          label: '修改人',
          prop: 'updateBy',
          visible: true,
          type: 'string',
          fill: false,
          width: 120
        },
        {
          label: '修改时间',
          prop: 'updateTime',
          visible: true,
          type: 'string',
          fill: false,
          width: 180
        },
        {
          label: '备注',
          prop: 'remark',
          visible: true,
          type: 'input',
          fill: true,
          width: 150,
          render: (_, row, col, disabled) => {
            return (
              <div>
                {
                  <el-input modelValue={row[col.prop]}
                    onUpdate:modelValue={(value) => {
                      row[col.prop] = value;
                      submitChange(row, col);
                    }}
                    placeholder=""
                    disabled={disabled}
                    clearable>
                  </el-input>
                }
              </div>
            )
          },
        }
      ],
      visible: true
    }
  ]
}

// 零食陈列
export const getSnackCofing = (submitChange) => {
  return [
    // 一级类
    {
      label: "基础信息",
      children: [
        // {
        //   label: '操作提示',
        //   prop: 'operationTip', // 列属性
        //   visible: true, // 是否显示
        //   type: 'string', // 列类型
        //   fill: true, // 是否为填报列
        //   fixed: 'left', // 是否固定在左侧
        //   width: 100,
        //   onlyFill: true, // 只在填报列显示
        //   render: (_, row, col) => {
        //     return (
        //       <div class="operation_tip_cell">
        //         <p>计划</p>
        //         <p>实际</p>
        //       </div>
        //     )
        //   }
        // },
        {
          label: '计划月份', // 列标题
          prop: 'salesMonth', // 列属性
          visible: true, // 是否显示
          type: 'string', // 列类型
          fill: false, // 是否为填报列
          width: 100
        },
        {
          "label": "销售大区",
          "prop": "regionName",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 100
        },
        {
          "label": "销售战区",
          "prop": "districtName",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 100
        },
        {
          "label": "经销商 - 省份",
          "prop": "dealerProvince",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 110
        },
        {
          "label": "经销商 - 城市",
          "prop": "dealerCity",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 110
        },
        {
          "label": "经销商 - 代码",
          "prop": "dealerCode",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 110
        },
        {
          "label": "经销商名称",
          "prop": "dealerName",
          "visible": true,
          "type": "string",
          "fill": true,
          "width": 200,
          fixed: 'left'
        },
        {
          "label": "经销商类型",
          "prop": "dealerType",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 150
        },
        {
          "label": "开户日期",
          "prop": "openingDate",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 100
        },
        {
          "label": "闭户日期",
          "prop": "closingDate",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 100
        },
        {
          "label": "大区总监",
          "prop": "regionManager",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 100
        },
        {
          "label": "战区经理",
          "prop": "districtManager",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 100
        },
        {
          "label": "城市经理",
          "prop": "cityManager",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 100
        },
        {
          "label": "系统名称",
          "prop": "lineName",
          "visible": true,
          "type": "string",
          "fill": true,
          "width": 100,
          fixed: 'left'
        },
        {
          "label": "系统类型",
          "prop": "lineType",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 100
        },
        {
          "label": "渠道大类",
          "prop": "channelDl",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 100
        },
        {
          "label": "渠道小类",
          "prop": "channelXl",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 100
        },
        {
          "label": "系统业态",
          "prop": "lineLf",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 100
        },
        {
          "label": "是否直营",
          "prop": "isDirect",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 100
        }
      ],
      prop: 'baseColumns',
      visible: true
    },
    {
      label: "零食折扣门店陈列计划",
      children: [
        {
          "label": "门店编码",
          "prop": "storeCode",
          "visible": true,
          "type": "string",
          "fill": true,
          "width": 150,
          fixed: 'left'
        },
        {
          "label": "门店名称",
          "prop": "storeName",
          "visible": true,
          "type": "string",
          "fill": true,
          "width": 180,
          fixed: 'left'
        },
        // {
        //   "label": "门店计数",
        //   "prop": "storeCount",
        //   "visible": true,
        //   "type": "string",
        //   "fill": false,
        //   "width": 100
        // },
        {
          "label": "门店地址",
          "prop": "storeAddress",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 280
        },
        {
          "label": "陈列形式",
          subLabel: '计划',
          "prop": "plannedDisplay",
          "visible": true,
          "type": "string",
          "fill": true,
          "width": 190
        },
        {
          "label": "陈列形式",
          subLabel: '实际',
          "prop": "actualDisplay",
          "visible": true,
          "type": "input",
          options: [
            {
              label: '执行与计划一致',
              value: '执行与计划一致'
            },
            {
              label: '执行与计划不一致',
              value: '执行与计划不一致'
            }
          ],
          referenceKey: "plannedDisplay",
          render: (_, row, col, disabled) => {
            return (
              <div>
                {row[col.referenceKey] ? <div style="width: 100%">
                  <el-select modelValue={row[col.prop]}
                    onUpdate:modelValue={(value) => {
                      row[col.prop] = value;
                      submitChange(row, col);
                    }}
                    disabled={!row[col.referenceKey] || disabled}
                    class={{ 'no-disabled': row[col.referenceKey] }}
                    placeholder=""
                    clearable
                  >
                    {col.options.map(item => (
                      <el-option key={item.value} label={item.label} value={item.value} />
                    ))}
                  </el-select>
                </div> : '-'}
              </div>
            )
          },
          "fill": true,
          "width": 190,
          // "options": [
          //   {
          //     "label": "端架",
          //     "value": "端架"
          //   },
          //   {
          //     "label": "收银台",
          //     "value": "收银台"
          //   },
          //   {
          //     "label": "端架和收银台",
          //     "value": "端架和收银台"
          //   }
          // ],
          // render: (_, row, col) => {
          //   return (
          //     <div>
          //       <el-tooltip placement="top" content={row[col.referenceKey] || '-'} disabled={!isContentOverflow(col.referenceKey, row[col.referenceKey], col)}>
          //         <span style="white-space: nowrap; overflow: hidden; text-overflow: ellipsis; display: inline-block; max-width: 100%;">
          //           {row[col.referenceKey] || '-'}
          //         </span>
          //       </el-tooltip>
          //       <el-select modelValue={row[col.prop]}
          //         onUpdate:modelValue={(value) => {
          //           row[col.prop] = value;
          //           submitChange(row, col);
          //         }}
          //         disabled={!row[col.referenceKey]}
          //         placeholder="">
          //         {col.options.map(item => (
          //           <el-option
          //             key={item.value}
          //             label={item.label}
          //             value={item.value}
          //           />
          //         ))}
          //       </el-select>
          //     </div>
          //   )
          // },
          requestKey: ["displayExecuted", "snackDisplayExecuted"]
          // requestKey: ["displayExecuted"]
        },
        // {
        //   "label": "陈列形式是否执行",
        //   "prop": "displayExecuted",
        //   "visible": true,
        //   "type": "formula",
        //   "fill": false,
        //   "width": 150,
        //   func: (row) => {
        //     if (!row.plannedDisplay) {
        //       row.displayExecuted = '-'
        //       return '-';
        //     }
        //     // 截取计划陈列形式数据
        //     row.displayExecuted = row.actualDisplay === '执行与计划一致' ? '执行' : '未执行'
        //     return row.displayExecuted
        //   },
        //   formulaStr: "实际陈列形式 === 计划陈列形式"
        // },
        {
          "label": "端架数量（组）",
          subLabel: '计划',
          "prop": "plannedEndCapQty",
          "visible": true,
          "type": "string",
          "fill": true,
          "width": 190
        },
        {
          "label": "端架数量（组）",
          subLabel: '实际',
          "prop": "actualEndCapQty",
          "visible": true,
          "type": "input",
          referenceKey: "plannedEndCapQty",
          "fill": true,
          // "options": [
          //   {
          //     "label": "0",
          //     "value": 0
          //   },
          //   {
          //     "label": "0.5",
          //     "value": 0.5
          //   },
          //   {
          //     "label": "1",
          //     "value": 1
          //   },
          //   {
          //     "label": "2",
          //     "value": 2
          //   }
          // ],
          render: (_, row, col, disabled) => {
            return (
              <div>
                <div>
                  {row[col.referenceKey] ? <el-input modelValue={row[col.prop]}
                    onUpdate:modelValue={(value) => {
                      row[col.prop] = value;
                      submitChange(row, col);
                    }}
                    disabled={disabled}
                    class={{ 'no-disabled': row[col.referenceKey], 'no-spinner': true, 'red-text': row[col.prop] > row[col.referenceKey] }}
                    min="0"
                    type="number"
                    placeholder=""
                    clearable
                  /> : '-'}
                </div>
              </div>
            )
          },
          "width": 190,
          requestKey: ["endCapQtyExecuted", "snackDisplayExecuted"]
        },
        {
          "label": "端架数量是否执行",
          "prop": "endCapQtyExecuted",
          "visible": true,
          "type": "formula",
          "fill": false,
          "width": 150,
          func: (row) => {
            // 截取计划端架数量数据
            row.endCapQtyExecuted = row.actualEndCapQty >= row.plannedEndCapQty ? '执行' : '未执行'
          },
          formulaStr: "端架数量实际 == 端架数量计划"
        },
        {
          "label": "零食陈列是否执行",
          "prop": "snackDisplayExecuted",
          "visible": true,
          "type": "formula",
          "fill": true,
          "width": 150,
          func: (row) => {
            if ((row.plannedDisplay && row.actualDisplay === '执行与计划一致')) {
              // 判断端架数量实际>=端架数量计划时为执行
              if (row.actualEndCapQty >= row.plannedEndCapQty) {
                row.snackDisplayExecuted = '执行'
              } else {
                row.snackDisplayExecuted = '未执行'
              }
            } else {
              row.snackDisplayExecuted = '未执行'
            }
          },
          formulaStr: "公式：陈列形式执行，并且端架数量实际>=端架数量计划（某项无计划时，忽略该项）"
        },
        {
          "label": "计划 - 陈列费用",
          "prop": "totalCost",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 120
        },
        {
          "label": "付费陈列 - 是否",
          "prop": "paidDisplay",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 120
        },
        {
          "label": "当月拜访目标 - 是否",
          "prop": "monthlyVisitTarget",
          "visible": true,
          "type": "string",
          "fill": false,
          "width": 150
        },
        {
          label: '修改人',
          prop: 'updateBy',
          visible: true,
          type: 'string',
          fill: false,
          width: 120
        },
        {
          label: '修改时间',
          prop: 'updateTime',
          visible: true,
          type: 'string',
          fill: false,
          width: 180
        },
        {
          label: '备注',
          prop: 'remark',
          visible: true,
          type: 'input',
          fill: true,
          width: 150,
          render: (_, row, col, disabled) => {
            return (
              <div>
                {
                  <el-input modelValue={row[col.prop]}
                    onUpdate:modelValue={(value) => {
                      row[col.prop] = value;
                      submitChange(row, col);
                    }}
                    placeholder=""
                    disabled={disabled}
                    clearable>
                  </el-input>
                }
              </div>
            )
          },
        }
      ],
      prop: 'snackColumns',
      visible: true
    }
  ]
}

// 三米两秒
export const getThreeTwoSecondsConfig = (submitChange) => {
  return [
    // 基础信息分组
    {
      label: "基础信息",
      children: [
        // {
        //   label: '操作提示',
        //   prop: 'operationTip', // 列属性
        //   visible: true, // 是否显示
        //   type: 'string', // 列类型
        //   fill: true, // 是否为填报列
        //   fixed: 'left', // 是否固定在左侧
        //   width: 100,
        //   onlyFill: true, // 只在填报列显示
        //   render: (_, row, col) => {
        //     return (
        //       <div class="operation_tip_cell">
        //         <p>计划</p>
        //         <p>实际</p>
        //       </div>
        //     )
        //   }
        // },
        {
          label: '计划月份', // 列标题
          prop: 'salesMonth', // 列属性
          visible: true, // 是否显示
          type: 'string', // 列类型
          fill: false, // 是否为填报列
          width: 100
        },
        {
          label: '销售大区',
          prop: 'regionName',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '销售战区',
          prop: 'districtName',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '经销商-省份',
          prop: 'dealerProvince',
          visible: true,
          type: 'string',
          fill: false,
          width: 120
        },
        {
          label: '经销商-城市',
          prop: 'dealerCity',
          visible: true,
          type: 'string',
          fill: false,
          width: 120
        },
        {
          label: '经销商-代码',
          prop: 'dealerCode',
          visible: true,
          type: 'string',
          fill: false,
          width: 120
        },
        {
          label: '经销商名称',
          prop: 'dealerName',
          visible: true,
          type: 'string',
          fill: true,
          width: 200,
          fixed: 'left'
        },
        {
          label: '大区总监',
          prop: 'regionManager',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '战区经理',
          prop: 'districtManager',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '城市经理',
          prop: 'cityManager',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '门店编码',
          prop: 'storeCode',
          visible: true,
          type: 'string',
          fill: true,
          width: 150,
          fixed: 'left'
        },
        {
          label: '门店名称',
          prop: 'storeName',
          visible: true,
          type: 'string',
          fill: true,
          fixed: true,
          width: 180
        },
        {
          label: '门店-省份',
          prop: 'storeProvince',
          visible: true,
          type: 'string',
          fill: false,
          width: 120
        },
        {
          label: '门店-城市',
          prop: 'storeCity',
          visible: true,
          type: 'string',
          fill: false,
          width: 120
        },
        {
          label: '系统名称',
          prop: 'lineName',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '系统类型',
          prop: 'lineType',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '渠道大类',
          prop: 'channelDl',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '渠道小类',
          prop: 'channelXl',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '门店类型',
          prop: 'storeType',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '系统业态',
          prop: 'lineLf',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        }
      ],
      prop: 'baseInfoColumns',
      visible: true
    },
    // 60g挂条陈列分组
    {
      label: "60g挂条陈列",
      children: [
        {
          label: '60g挂条陈列数量',
          subLabel: '计划',
          prop: 'plannedDisplayQty60',
          visible: true,
          type: 'string',
          fill: true,
          width: 200
        },
        {
          label: '60g挂条陈列费',
          prop: 'totalCost60',
          visible: true,
          type: 'string',
          fill: false,
          width: 140
        },
        {
          label: '60g挂条陈列数量',
          subLabel: '实际',
          prop: 'actualDisplayQty60',
          referenceKey: 'plannedDisplayQty60',
          visible: true,
          type: 'input',
          fill: true,
          width: 200,
          render: (_, row, col, disabled) => {
            return (
              <div style="padding: 10px 0;">
                <div>
                  {row[col.referenceKey] ? <el-input
                    modelValue={row[col.prop]}
                    onUpdate:modelValue={(value) => {
                      row[col.prop] = value;
                      submitChange(row, col);
                    }}
                    disabled={disabled}
                    min="0"
                    type="number"
                    class={{ 'no-disabled': row[col.referenceKey], 'no-spinner': true, 'red-text': row[col.prop] > row[col.referenceKey] }}
                    placeholder=""
                    clearable
                  /> : '-'}
                </div>
              </div>
            );
          },
          requestKey: ["displayQtyExecuted60"]
        },
        // 60g挂条陈列-是否执行
        {
          label: '60g挂条陈列是否',
          subLabel: '按计划执行',
          prop: 'displayQtyExecuted60',
          visible: true,
          type: 'formula',
          func: (row) => {
            // 判断区间，未执行，部分执行，执行
            if (row.actualDisplayQty60 < row.plannedDisplayQty60) {
              row.displayQtyExecuted60 = '未执行'
              return '未执行'
            } else {
              row.displayQtyExecuted60 = '执行'
              return '执行'
            }
          },
          formulaStr: '公式：（60g挂条陈列数量实际 >= 60g挂条陈列数量计划）',
          fill: true,
          width: 200
        },
        {
          label: '备注',
          prop: 'remark',
          visible: true,
          type: 'input',
          fill: true,
          width: 150,
          render: (_, row, col, disabled) => {
            return (
              <div>
                {
                  <el-input modelValue={row[col.prop]}
                    onUpdate:modelValue={(value) => {
                      row[col.prop] = value;
                      submitChange(row, col);
                    }}
                    placeholder=""
                    disabled={disabled}
                    clearable>
                  </el-input>
                }
              </div>
            )
          },
        }
      ],
      prop: 'sixtyGramHangBarColumns',
      visible: true
    }
  ]
}

// 六小金刚
export const getSixLittleDiamondsConfig = (submitChange) => {
  return [
    // 基础信息分组
    {
      label: "基础信息",
      children: [
        // {
        //   label: '操作提示',
        //   prop: 'operationTip', // 列属性
        //   visible: true, // 是否显示
        //   type: 'string', // 列类型
        //   fill: true, // 是否为填报列
        //   fixed: 'left', // 是否固定在左侧
        //   width: 100,
        //   onlyFill: true, // 只在填报列显示
        //   render: (_, row, col) => {
        //     return (
        //       <div class="operation_tip_cell">
        //         <p>计划</p>
        //         <p>实际</p>
        //       </div>
        //     )
        //   }
        // },
        {
          label: '计划月份', // 列标题
          prop: 'salesMonth', // 列属性
          visible: true, // 是否显示
          type: 'string', // 列类型
          fill: false, // 是否为填报列
          width: 100
        },
        {
          label: '销售大区',
          prop: 'regionName',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '销售战区',
          prop: 'districtName',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '经销商-省份',
          prop: 'dealerProvince',
          visible: true,
          type: 'string',
          fill: false,
          width: 120
        },
        {
          label: '经销商-城市',
          prop: 'dealerCity',
          visible: true,
          type: 'string',
          fill: false,
          width: 120
        },
        {
          label: '经销商-代码',
          prop: 'dealerCode',
          visible: true,
          type: 'string',
          fill: false,
          width: 120
        },
        {
          label: '经销商名称',
          prop: 'dealerName',
          visible: true,
          type: 'string',
          fill: true,
          width: 200,
          fixed: 'left'
        },
        {
          label: '大区总监',
          prop: 'regionManager',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '战区经理',
          prop: 'districtManager',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '城市经理',
          prop: 'cityManager',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '门店编码',
          prop: 'storeCode',
          visible: true,
          type: 'string',
          fill: true,
          width: 150,
          fixed: 'left'
        },
        {
          label: '门店名称',
          prop: 'storeName',
          visible: true,
          type: 'string',
          fill: true,
          fixed: true,
          width: 180
        },
        {
          label: '门店-省份',
          prop: 'storeProvince',
          visible: true,
          type: 'string',
          fill: false,
          width: 120
        },
        {
          label: '门店-城市',
          prop: 'storeCity',
          visible: true,
          type: 'string',
          fill: false,
          width: 120
        },
        {
          label: '系统名称',
          prop: 'lineName',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '系统类型',
          prop: 'lineType',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '渠道大类',
          prop: 'channelDl',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '渠道小类',
          prop: 'channelXl',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '门店类型',
          prop: 'storeType',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        },
        {
          label: '系统业态',
          prop: 'lineLf',
          visible: true,
          type: 'string',
          fill: false,
          width: 100
        }
      ],
      prop: 'baseInfoColumns',
      visible: true
    },
    // 六小金刚批发挂网分组
    {
      label: "六小金刚批发挂网",
      children: [
        {
          label: '六小金刚批发挂网',
          subLabel: '计划',
          prop: 'plannedGw6',
          visible: true,
          type: 'string',
          fill: true,
          width: 210
        },
        {
          label: '六小金刚批发挂网',
          subLabel: '实际',
          prop: 'actualGw6',
          referenceKey: 'plannedGw6',
          visible: true,
          type: 'select',
          // options: [
          //   // { label: '是', value: '是' },
          //   // { label: '否', value: '否' }
          //   // { label: 0, value: 0 },
          //   // { label: 1, value: 1 },
          //   // { label: '其他', value: '其他' }
          // ],
          render: (_, row, col, disabled) => {
            return (
              <div style="padding: 10px 0;">
                {row[col.referenceKey] ? <el-input modelValue={row[col.prop]}
                  onUpdate:modelValue={(value) => {
                    row[col.prop] = value;
                    submitChange(row, col);
                  }}
                  disabled={disabled}
                  class={{ 'no-disabled': row[col.referenceKey], 'no-spinner': true, 'red-text': row[col.prop] > row[col.referenceKey] }}
                  min="0"
                  type="number"
                  placeholder=""
                  clearable>
                </el-input> : '-'}
              </div>
            )
          },
          fill: true,
          width: 210,
          requestKey: ['gwExecuted6']
        },
        {
          label: '六小金刚批发挂网陈列费',
          prop: 'totalCostGw6',
          visible: true,
          type: 'string',
          fill: false,
          width: 160
        },
        {
          label: '六小金刚批发挂网是否',
          subLabel: '按计划执行',
          prop: 'gwExecuted6',
          visible: true,
          type: 'formula',
          func: (row) => {
            // 实际不等于计划的都是未执行
            if (row.actualGw6 !== row.plannedGw6) {
              row.gwExecuted6 = '未执行'
            } else {
              row.gwExecuted6 = '执行'
            }
          },
          formulaStr: '公式：（六小金刚批发挂网实际 = 六小金刚批发挂网计划）',
          fill: true,
          width: 210
        },
        {
          label: '备注',
          prop: 'remark',
          visible: true,
          type: 'input',
          fill: true,
          width: 150,
          render: (_, row, col, disabled) => {
            return (
              <div>
                {
                  <el-input modelValue={row[col.prop]}
                    onUpdate:modelValue={(value) => {
                      row[col.prop] = value;
                      submitChange(row, col);
                    }}
                    placeholder=""
                    disabled={disabled}
                    clearable>
                  </el-input>
                }
              </div>
            )
          },
        }
      ],
      prop: 'wholesaleNetColumns',
      visible: true
    }
  ]
}
