import request, { promotionBaseURL } from '@/utils/request'
import { parseTime } from '@/utils'

// 战区列表
export const getWarZoneListAPI = () => {
  return request({
    url: promotionBaseURL + '/user/dept/query/enroll/list',
    method: 'POST',
    data: {
      "orgNameLike1": "战区",
      // "orgName1": "重客运营部"
    }
  })
}

// 负责人列表
export const getChargeListAPI = () => {
  return request({
    url: promotionBaseURL + '/user/employee/query/enroll/list',
    method: 'POST',
    data: {
      "waiqin365OrgId": '',
      "empName": '',
      "qcId": ''
    }
  })
}

// 任务列表
export const getTaskListAPI = (queryParams) => {
  return request({
    url: promotionBaseURL + '/activity/employee/query/page',
    headers: {
      isToken: false,
      'Authorization': 'eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ1c2VybmFtZSI6IjAwMDUxNiIsInBhc3N3b3JkIjoid3hsMDAwNTE2IiwidGltZSI6MTczNzA4MjM3ODQ0MX0.z8pOrprMgfOk5MGEKCL-KNokLgCPqDRt8suEYEnnQ-U',
    },
    method: 'POST',
    data: {
      "pageNum": queryParams.page,
      "pageSize": queryParams.pageSize,
      "queryParams": {
        "deptQcId": queryParams.zoneId,
        "createDateStart": parseTime(queryParams.date[0], '{y}-{m}-{d}'),
        // "createDateStart": '2025-01-12 00:00:00',
        "createDateEnd": parseTime(queryParams.date[1], '{y}-{m}-{d}'),
        // "createDateEnd": '2025-01-14 23:59:59',
        "province": queryParams.province,
        "city": queryParams.city,
        "approverId": '',
        "approveStatus": queryParams.taskStatus,
        "storeNameLike": queryParams.storeName,
      }
    }
  })
}