import vue from '@vitejs/plugin-vue'

import createAutoImport from './auto-import'
import createAutoImportVant from './auto-import-vant'
import createSvgIcon from './svg-icon'
import createCompression from './compression'
import createSetupExtend from './setup-extend'
import createHtmlPlugin from './create-html'

export default function createVitePlugins(viteEnv, isBuild = false) {
  const vitePlugins = [vue()]
  vitePlugins.push(...createAutoImportVant())
  vitePlugins.push(createAutoImport())
  vitePlugins.push(createSetupExtend())
  vitePlugins.push(createSvgIcon(isBuild))
  vitePlugins.push(createHtmlPlugin(viteEnv))
  isBuild && vitePlugins.push(...createCompression(viteEnv))
  return vitePlugins
}
