import request from '@/utils/request'
import { parseTime } from '@/utils'


/**
 * 直播间列表
 * @returns 
 */
export const getBrandListAPI = () => {
  return request({
    url: '/bi/finance/zbjType/list'
  })
}

/**
 * 口味列表
 * @returns 
 */
export const getTasteListAPI = () => {
  return request({
    url: '/bi/finance/flavor/list'
  })
}

/**
 * 规格列表
 * @returns 
 */
export const getSpecListAPI = () => {
  return request({
    url: '/bi/finance/spec/list'
  })
}

/**
 * 获取财务列表
 * @param {*} data
 * @returns 
 */
export const getFinanceListAPI = (data) => {
  return request({
    url: '/bi/finance/cost/list',
    method: 'POST',
    data: {
      zbjQdType: data.zbjQdType,
      flavor: data.flavorErp,
      specName: data.specNameErp,
      zbjQdTypeAll: data.zbjQdTypeAll,
      flavorErpAll: data.flavorErpAll,
      specNameErpAll: data.specNameErpAll,
      series: data.seriesPrdMap.map(o => o[0]),
      goodsName: data.seriesPrdMap.map(o => o[1]),
      startDate: parseTime(data.date[0], `{y}-{m}-{d}`),
      endDate:  parseTime(data.date[1], `{y}-{m}-{d}`)
    }
  })
}

export const getFinanceDetailAPI = (data) => {
  return request({
    url: '/bi/finance/cost/detail/list',
    method: 'POST',
    data: {
      zbjQdType: data.zbjQdType,
      flavor: data.flavorErp,
      specName: data.specNameErp,
      zbjQdTypeAll: data.zbjQdTypeAll,
      flavorErpAll: data.flavorErpAll,
      specNameErpAll: data.specNameErpAll,
      series: data.seriesPrdMap.map(o => o[0]),
      goodsName: data.seriesPrdMap.map(o => o[1]),
      startDate: parseTime(data.date[0], `{y}-{m}-{d}`),
      endDate:  parseTime(data.date[1], `{y}-{m}-{d}`),
      pageNum: data.pageNum,
      pageSize: data.pageSize
    }
  })
}