/**
 * 判断计划是否可编辑/删除
 * @param {*} row 计划信息对象
 * @returns boolean true 可编辑/删除，false 不可编辑/删除
 */
export const checkPlanExpire = (row) => {
  // 1. 计划日期已经 1 小时后，不可编辑/删除
  const date = new Date()
  const rowDate = new Date(row.clockInTime)
  rowDate.setHours(rowDate.getHours() + 1)
  // 2. 计划状态已经开始了，不可编辑/删除
  return !(rowDate < date || row.planStatus === 1)
}