// 长按手势指令
import { ref } from 'vue';

const longPressDuration = ref(500); // 长按时间阈值，单位毫秒
let start = null; // 记录触摸开始时间
let cancel = null;

export default {
  beforeMount(el, binding) {
    let pressTimer = null;

    start = (e) => {
      if (pressTimer === null) {
        pressTimer = setTimeout(() => {
          binding.value();
        }, longPressDuration.value);
      }
    };

    cancel = (e) => {
      if (pressTimer !== null) {
        clearTimeout(pressTimer);
        pressTimer = null;
      }
    };

    el.addEventListener('touchstart', start);
    el.addEventListener('touchend', cancel);
    el.addEventListener('touchcancel', cancel);
  },
  unmounted(el) {
    el.removeEventListener('touchstart', start);
    el.removeEventListener('touchend', cancel);
    el.removeEventListener('touchcancel', cancel);
  }

};